/*
 * 15/03/2009, 17:06.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.mensagemprivada;

import br.com.simuquiz.entidades.MensagemPrivada;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.Collection;

/**
 * Classe responsvel por representar a funcionalidade de listar mensagens
 * privadas recebidas pelo usurio.
 * @author Pedro Lopes de Souza
 */
@JsonMarshal
public class FuncionalidadeListarMensagensPrivadas implements Serializable {

    private static final long serialVersionUID = 2752402811290439294L;

    private final Usuario usuario;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;

    private final Collection<MensagemPrivada> mensagens;

    public enum TiposErros { ERRO }

    public FuncionalidadeListarMensagensPrivadas(Usuario usuario, Integer primeiro, Integer quantidade) {

        if (usuario == null) {
            throw new IllegalArgumentException();
        }

        if (primeiro == null) primeiro = 0;
        if (quantidade == null) quantidade = 10;

        this.problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);
        this.usuario = usuario;

        Collection<MensagemPrivada> m = null;
        try {
            m = usuario.listarCaixaDeEntrada(primeiro, quantidade);
        } catch (Throwable t) {
            problemas.adicionarProblema(TiposErros.ERRO, t);
            t.printStackTrace();
            // TODO: Gerar log.
        }
        mensagens = m;

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public Usuario getUsuario() {
        return usuario;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }

    @JsonMarshal
    public Collection<MensagemPrivada> getMensagens() {
        return mensagens;
    }
}
