/*
 * 15/03/2009, 17:06.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.funcionalidades.mensagemprivada;

import br.com.simuquiz.entidades.MensagemPrivada;
import br.com.simuquiz.entidades.Usuario;
import br.com.simuquiz.funcionalidades.RelatorioProblemas;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;

/**
 * Classe responsvel por representar a funcionalidade de ler mensagens
 * privadas contendo os dados da tela informados pelo usurio.
 *
 * OBSERVAO: FUNCIONALIDADE INCOMPLETA!
 *
 * @author Pedro Lopes de Souza
 */
@JsonMarshal
public class FuncionalidadeLerMensagemPrivada implements Serializable {

    private static final long serialVersionUID = -7750341586459085310L;

    private final Usuario usuario;

    private final MensagemPrivada mensagem;

    private final Long idMensagem;

    /** Relao de problemas ocorridos. */
    private final RelatorioProblemas<TiposErros> problemas;

    public enum TiposErros { ERRO }

    public FuncionalidadeLerMensagemPrivada(Usuario usuario, Long idMensagem) {

        if (usuario == null) {
            throw new IllegalArgumentException();
        }

        this.problemas = new RelatorioProblemas<TiposErros>(TiposErros.class);
        this.usuario = usuario;
        this.idMensagem = idMensagem;

        if (idMensagem == null) {
            problemas.adicionarProblema(TiposErros.ERRO, "Essa mensagem no  para esse usurio.");
        }

        MensagemPrivada mp = null;
        if (problemas.isVazio()) {
            try {
                mp = MensagemPrivada.pesquisarPorId(idMensagem);
            } catch (Throwable t) {
                problemas.adicionarProblema(TiposErros.ERRO, t);
                t.printStackTrace();
                // TODO: Acrescentar log.
            }
        }
        mensagem = mp;

        if (problemas.isVazio() && (mensagem == null ||
                (usuario != mensagem.getDestinatario() && usuario != mensagem.getRemetente()))) {
            problemas.adicionarProblema(TiposErros.ERRO, "Essa mensagem no  para esse usurio.");
        }

        // Finaliza o processo e se torna apenas um bean.
        problemas.fechar();
    }

    @JsonMarshal
    public Usuario getUsuario() {
        return usuario;
    }

    @JsonMarshal
    public MensagemPrivada getMensagemPrivada() {
        return mensagem;
    }

    @JsonMarshal
    public Long getIdMensagem() {
        return idMensagem;
    }

    @JsonMarshal
    public RelatorioProblemas getProblemas() {
        return problemas;
    }

    @JsonMarshal
    public boolean isSucesso() {
        return problemas.isVazio();
    }
}
