/*
 * 15/05/2009, 20:59.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.funcionalidades.exame.cadastro;

import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;

/**
 * @author Victor Williams Stafusa da Silva
 */
public class Entrada implements Serializable {

    private static final long serialVersionUID = -6076637582571830607L;

    private final String nome;
    private final String descricaoCurta;
    private final String descricaoCompleta;
    private final Object especifico;

    public Entrada(String nome, String descricaoCurta, String descricaoCompleta, Object especifico) {
        this.nome = nome;
        this.descricaoCompleta = descricaoCompleta;
        this.descricaoCurta = descricaoCurta;
        this.especifico = especifico;
    }

    /**
     * Retorna o nome do exame informado pelo usurio.
     * @return O nome do exame informado pelo usurio.
     */
    @JsonMarshal
    public String getNome() {
        return nome;
    }

    /**
     * Retorna a descrio curta do exame informada pelo usurio.
     * @return A descrio curta do exame informada pelo usurio.
     */
    @JsonMarshal
    public String getDescricaoCurta() {
        return descricaoCurta;
    }

    /**
     * Retorna a descrio completa do exame informada pelo usurio.
     * @return A descrio completa do exame informada pelo usurio.
     */
    @JsonMarshal
    public String getDescricaoCompleta() {
        return descricaoCompleta;
    }

    @JsonMarshal
    public Object getEspecifico() {
        return especifico;
    }
}
