/*
 * 07/03/2009, 22:56.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

/**
 * @author Victor Williams Stafusa da Silva
 */
@Entity
@JsonMarshal
public class QuestaoVersao implements Serializable {

    private static final long serialVersionUID = -6811668589061032573L;

    @Id
    @GeneratedValue
    private long idQuestaoVersao;

    @ManyToOne
    @JoinColumn(name="Id_Questao")
    @ContainedIn
    private Questao questao;

    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String enunciado;

    //@Enumerated(EnumType.ORDINAL)
    //private TipoQuestao tipo;

    @ManyToOne
    @JoinColumn(name="Id_Usuario_Revisor")
    private Usuario revisor;

    @Temporal(TemporalType.TIMESTAMP)
    private Date dataHistorico;

    private int minCorretas;

    private int maxCorretas;

    private int minAlternativas;

    private int maxAlternativas;

    @IndexedEmbedded
    @OneToMany(fetch=FetchType.EAGER, mappedBy="questaoVersao")
    @MapKey(name="ordemAlternativa")
    private Map<Integer, Alternativa> alternativas;

    @Version
    private Integer version;

    public QuestaoVersao() {}

    @JsonMarshal
    public long getIdQuestaoVersao() {
        return idQuestaoVersao;
    }

    @JsonMarshal
    public String getEnunciado() {
        return enunciado;
    }

    @JsonMarshal
    public Usuario getRevisor() {
        return revisor;
    }

    @JsonMarshal
    public Date getDataHistorico() {
        return dataHistorico;
    }

    @JsonMarshal
    public int getMinCorretas() {
        return minCorretas;
    }

    @JsonMarshal
    public int getMaxCorretas() {
        return maxCorretas;
    }

    @JsonMarshal
    public int getMinAlternativas() {
        return minAlternativas;
    }

    @JsonMarshal
    public int getMaxAlternativas() {
        return maxAlternativas;
    }

    @JsonMarshal
    public Collection<Alternativa> getAlternativas() {
        return alternativas.values();
    }

    public Map<Integer, Alternativa> mapaAlternativas() {
        return alternativas;
    }

    @JsonMarshal
    public double getProbabilidadeDeAcertar() {
        Query q = Database.getEntityManager().createQuery("select qp from QuestaoProva qp where qp.questaoVersao = :questao");
        q.setParameter("questao", this);
        int totalAcertosProvas = 0;
        int totalAcertosNestaQuestao = 0;

        @SuppressWarnings("unchecked") Collection<QuestaoProva> questoes = (Collection<QuestaoProva>) q.getResultList();
        for (QuestaoProva qp : questoes) {
            Prova p = qp.getProva();
            if (!p.isFinalizada()) continue;
            int acertosProva = p.getQuantidadeAcertos();
            totalAcertosProvas += acertosProva;
            if (qp.isCorreta()) totalAcertosNestaQuestao += acertosProva;
        }

        return (totalAcertosProvas == 0 && totalAcertosNestaQuestao == 0) ? -1.0 :
                totalAcertosProvas == 0 ? 0.0 : (double) totalAcertosNestaQuestao / (double) totalAcertosProvas;
    }

    // Visibilidade de pacote. Deve ser usado apenas pela classe Questao.
    static QuestaoVersao novo(EntityManager em, Questao questao, String enunciado, Usuario revisor, int minCorretas, int maxCorretas, int minAlternativas, int maxAlternativas, List<String> textoAlternativas, Set<Integer> corretas) {
        QuestaoVersao questaoVersao = new QuestaoVersao();
        questaoVersao.questao = questao;
        questaoVersao.enunciado = enunciado;
        questaoVersao.revisor = revisor;
        questaoVersao.minCorretas = minCorretas;
        questaoVersao.maxCorretas = maxCorretas;
        questaoVersao.minAlternativas = minAlternativas;
        questaoVersao.maxAlternativas = maxAlternativas;

        questaoVersao.alternativas = new HashMap<Integer, Alternativa>(textoAlternativas.size());
        em.persist(questaoVersao);

        int i = 0;
        for (String textoAlternativa : textoAlternativas) {
            questaoVersao.alternativas.put(i, Alternativa.novo(em, questaoVersao, textoAlternativa, corretas.contains(i)));
            i++;
        }

        em.merge(questaoVersao);
        em.flush();

        return questaoVersao;
    }
}
