/*
 * 07/03/2009, 22:50.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.conexao.Database;
import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Version;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.IndexedEmbedded;

/**
 * @author Victor Williams Stafusa da Silva
 * @author Pedro Lopes de Souza
 */
@Entity
@JsonMarshal
public class Questao implements Serializable {

    private static final long serialVersionUID = -2534719778910748555L;

    @Id
    @GeneratedValue
    private long idQuestao;

    @ContainedIn
    @ManyToOne
    @JoinColumn(name="Id_Exame")
    private Exame exame;

    @OneToOne
    @IndexedEmbedded
    private QuestaoVersao versaoEmUso;

    @Version
    private Integer version;

    public Questao() {}

    @JsonMarshal
    public long getIdQuestao() {
        return idQuestao;
    }

    @JsonMarshal
    public Exame getExame() {
        return exame;
    }

    @JsonMarshal
    public QuestaoVersao getVersaoEmUso() {
        return versaoEmUso;
    }

    // Visibilidade de pacote. Deve ser usado apenas pela classe Exame.
    static Questao novo(EntityManager em, Exame exame, String enunciado, Usuario revisor, int minCorretas, int maxCorretas, int minAlternativas, int maxAlternativas, List<String> textoAlternativas, Set<Integer> corretas) {
        final Questao questao = new Questao();
        questao.exame = exame;
        em.persist(questao);
        questao.versaoEmUso = QuestaoVersao.novo(em, questao, enunciado, revisor, minCorretas, maxCorretas, minAlternativas, maxAlternativas, textoAlternativas, corretas);
        return questao;
    }

    public QuestaoVersao novaVersao(final String enunciado, final Usuario revisor, final int minCorretas, final int maxCorretas, final int minAlternativas, final int maxAlternativas, final List<String> textoAlternativas, final Set<Integer> corretas) {
        return Database.efetuarTransacao(new Database.Transacao<QuestaoVersao>() {
            @Override
            public QuestaoVersao efetuarTransacao(EntityManager em) {
                QuestaoVersao qv = QuestaoVersao.novo(em, Questao.this, enunciado, revisor, minCorretas, maxCorretas, minAlternativas, maxAlternativas, textoAlternativas, corretas);
                Questao.this.versaoEmUso = qv;
                em.merge(Questao.this);
                return qv;
            }
        });
    }

    public static Questao pesquisarPorId(long idQuestao) {
        return Database.getEntityManager().find(Questao.class, idQuestao);
    }
}
