/*
 * 08/03/2009, 09:23.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */
package br.com.simuquiz.entidades;

import br.com.simuquiz.util.JsonMarshal;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;

/**
 * Representa uma alternativa cadastrada em uma questo.
 * @author Victor Williams Stafusa da Silva
 */
@Entity
@JsonMarshal
public class Alternativa implements Serializable {

    private static final long serialVersionUID = 3448182440692009450L;

    /** Chave primria da alternativa. */
    @Id
    @GeneratedValue
    private long idAlternativa;

    /** Texto mostrado na alternativa. */
    @Field(index=Index.TOKENIZED, store=Store.YES)
    private String texto;

    /** Flag que indica se a alternativa  correta ou no. */
    private boolean correta;

    private int ordemAlternativa;

    /**
     * Verso de questo onde a alternativa se encontra.
     * No  suficiente mapear apenas a questo, porque esta pode vir a sofrer
     * alteraes e  importante manter-se um histrico disso.
     */
    @ManyToOne
    @JoinColumn(name="Id_Questao_Versao")
    @ContainedIn
    private QuestaoVersao questaoVersao;

    /**
     * Construtor nico.
     */
    public Alternativa() {}

    /**
     * Obtm a chave primria da alternativa.
     * @return A chave primria da alternativa.
     */
    @JsonMarshal
    public long getIdAlternativa() {
        return idAlternativa;
    }

    /**
     * Obtm o texto mostrado na alternativa.
     * @return O texto mostrado na alternativa.
     */
    @JsonMarshal
    public String getTexto() {
        return texto;
    }

    /**
     * Indica se a alternativa est correta ou no.
     * @return {@code true} se a alternativa for correta, {@code false} em caso
     * contrrio.
     */
    @JsonMarshal
    public boolean isCorreta() {
        return correta;
    }

    @JsonMarshal
    public int getOrdemAlternativa() {
        return ordemAlternativa;
    }

    /**
     * Cria uma nova alternativa de uma {@linkplain QuestaoVersao} informada.
     * Este mtodo deve ser usado apenas pela classe {@linkplain QuestaoVersao}.
     * @param questaoVersao A {@linkplain QuestaoVersao} a qual esta alternativa
     * est associada.
     * @param texto O texto da alternativa.
     * @param correta Define se a alternativa est correta ou no.
     * @return O bean da alternativa recm-criada.
     */
    static Alternativa novo(EntityManager em, QuestaoVersao questaoVersao, String texto, boolean correta) {
        Alternativa alternativa = new Alternativa();
        alternativa.texto = texto;
        alternativa.correta = correta;
        alternativa.questaoVersao = questaoVersao;

        em.persist(alternativa);
        em.flush();

        return alternativa;
    }
}
