/*
 * 18/06/2008, 01:13.
 *
 * Simuquiz - http://www.simuquiz.com.br
 */

package br.com.simuquiz.conexao;

import br.com.simuquiz.antispam.Trainer;
import br.com.simuquiz.entidades.Exame;
import br.com.simuquiz.entidades.MensagemPrivada;
import br.com.simuquiz.entidades.Prova;
import br.com.simuquiz.entidades.Treinamento;
import br.com.simuquiz.entidades.Usuario;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;

/**
 * @author Pedro Lopes de Souza
 * @author Victor Williams Stafusa da Silva
 */
public class PopulaBancoDeDados {

    private PopulaBancoDeDados() {}

    private static Trainer trainer;

    public static Trainer getTrainer() {
        return trainer;
    }

    public static void treinar() {
        Collection<Treinamento> t = Treinamento.listarTudo();
        trainer = new Trainer();
        trainer.train(t);
    }

    private static Set<Integer> ints(int... ints) {
        Set<Integer> set = new HashSet<Integer>();
        for (int i : ints) {
            set.add(i);
        }
        return set;
    }

    private static void fazerProva(Prova p) {
        for (int pog = 1; pog <= 10; pog++){
            for (int pog2 = 0; pog2 < 5; pog2++) {
                try {
                    p.responderQuestao(pog, ints(new Random().nextInt(p.getQuestao(pog).getTextosAlternativas().size())));
                    break;
                } catch (Exception e) {}
            }
        }
        p.finalizar();
    }

    public static void popularBancoDeDados() {
        Usuario pedro = Usuario.novo("Pedro Lopes de Souza", "desouza", "pedro", "pedro13lopes@hotmail.com");
        Usuario victor = Usuario.novo("Victor Williams Stafusa da Silva", "vwss1984", "victor", "victorwssilva@gmail.com");
        Usuario paula = Usuario.novo("Paula de Paola","paula_paola","paula","pauladepaola@gmail.com");
        Usuario spammer = Usuario.novo("Pharmacy online","spam","spam","pjjfhgjfhgkjf@ngngjkfbgkjf.com");
        Usuario fernanda = Usuario.novo("Fernanda Sinhorini", "fer_sin", "fernanda", "fefe_sinho@hotmail.com");

        Exame exameJava1 = victor.novoExame("Exame Java", "Questes sobre a linguagem Java e suas tecnologias.", "Esse exame visa analisar o conhecimento da linguagem de programao Java bem como as tecnologias que ela utiliza. No geral trata-se de questes relacionadas a sintaxe da linguagem.");
        Exame exameIdiota = victor.novoExame("Perguntas idiotas", "Crocodilos e duendes no andam de caminho.", "O arroz dos astronautas foi peneirado em um sbado dentro de um vulco criado as sobras das barbas do imperador Galileu. As fadas-madrinhas de Estevo gorgoleiam em verde e comem a paixo dos anjos albinos!");

        Exame examePort1 = pedro.novoExame("Interpretao de Texto", "Questes sobre interpretao de texto.", "Esse exame visa avaliar a capacidade da pessoa em interpretar corretamente texto baseado em conhecimentos previos e analisa semntica.");
        Exame exameAll1 = pedro.novoExame("Conhecimentos Gerais do Ensino Mdio", "Questes sobre algumas reas estudas no ensino mdio", "Esse exame visa avaliar os conhecimentos de nvel do ensino mdio nas reas de Histria, Geografia, Portugus, Qumica, Biologia e Matemtica.");

        Exame exameHisto1 = paula.novoExame("Histria - Conhecimentos Gerais", "Questes gerais sobre Histria do Brasil/Mundial", "Esse exame visa testar os conhecimentos gerais de ensino mdio da rea de Histria.");
        Exame exameGeo1 = paula.novoExame("Geografia - Conhecimentos Gerais", "Questes gerais sobre Geografia Fsica/Poltcia", "Esse exame visa testar os conhecimentos gerais de ensino mdio da rea de Geografia Fsica e Poltica.");

        Exame exameServlets = fernanda.novoExame("Servlets e JSP", "Passando no exame para certificado Desenvolverdor de Componentes Web da Sun", "Conjunto de questes que visa preparar o canditato para realizar a prova da Sun para o certificado de Desenvolvedor de Componestes Web");

        criarTreinamentos();
        treinar();

        MensagemPrivada.novo(paula, pedro, "Oi Pedro, \n A questao sua do exame de interpretacao de texto sobre o o conto de Guimaraes Rosa nao eh de interpretacao. Veja isso. \n Bjos, \n Paula", "Questso fora de contexto");
        MensagemPrivada.novo(paula, victor, "Oi Victor, \n Muito legal a sua prova sobre Java. Tirei muitas duvidas. Parabens. \n Paula", "Exame sobre Java");
        MensagemPrivada.novo(paula, fernanda, "Oiiii Fefe", "Oi fer, \n Tudo bom querida? Saudades de vc!! O que vc achou do site? Eu gostei muito!! \n Bjus paula");

        MensagemPrivada.novo(pedro, paula, "Oi Paula, \n Seja bem vinda ao Simuquiz. Caso tenha uma duvida por favor entre em contato para que possamos ajuda-la. \n Abracos, \n Pedro", "Bem-Vinda ao Simuquiz");
        MensagemPrivada.novo(pedro, paula, "Oi Paula, \n Vc tem razao. A questao nao bate muito bem com a proposta do exame. Vou rever isso. \n Pedro", "Resposta: Questao fora de Contexto");
        MensagemPrivada.novo(pedro, victor, "Envio realizado com sucesso", "Resposta: Teste Mensagem Privada 1");
        MensagemPrivada.novo(pedro, fernanda, "Resposta: Oi Pedro", "Ola Fernanda.\n Pelo visto  um problema aqui no site com o jQuery. No se preocupe que logo resolveremos isso.\n Abraos,\n Pedro ");

        MensagemPrivada.novo(victor, pedro, "Testando o envio de mensagens", "Teste Mensagem Privada 1");
        MensagemPrivada.novo(victor, paula, "Seja bem-vinda ao Simuquiz. Espero que goste do site.\n Victor", "Ol :)");
        MensagemPrivada.novo(victor, paula, "Fico feliz que tenha gostado do exame. Espero que tenha se saido bem. ^^", "Resposta: Exame sobre o Java");

        MensagemPrivada.novo(spammer, victor, "RE: VIAGRA  Official Site", "please click to view. please click to view. discount");
        MensagemPrivada.novo(spammer, pedro, "Soluo para seus problemas", "Quer ver gostosas peladas? Clique aqui para ver as fotos http:\\fotosnuas.com");

        MensagemPrivada.novo(fernanda, victor, "Ola", "Acabei de me cadastrar. Estou gostando muito do sites. Fernanda");
        MensagemPrivada.novo(fernanda, pedro, "Oi Pedro", "Estou com algumas duvidas para navegar no site. No consigo visualizar alguns icones. Voce poderia me ajudar com isso?");

        exameJava1.novaQuestao("Quais destas palavras so palavras-chave vlidas em java?",
                victor, 2, 3, 4, 5,
                Arrays.asList("void", "struct", "while", "return", "typedef", "function", "include", "class"),
                ints(0, 2, 3, 7));

        exameJava1.novaQuestao("Qual  a sada no console do seguinte programa?\n\n" +
                "1. public class Gag {\n" +
                "2.     public String xd;\n" +
                "3.     public static void main(String[] ui) {\n" +
                "4.     for (String k : ui){\n" +
                "5.       xd += (Integer.parseInt(k) == 24 ? \"ooo\" : \n" +
                "6.          Integer.parseInt(k) == 42 ? \"aaa\" : null);\n" +
                "7. }}}\n\n\njava Gag 12 23 44 24 42",
                victor, 1, 1, 6, 6,
                Arrays.asList("Nada  escrito no console", "nullnullnulloooaaa", "oooaaa", "aaaooo", "O cdigo no compila", "Uma exceo  lanada durante a execuo"),
                ints(4));

        exameJava1.novaQuestao("As unidades concorrentes em Java so objetos que incluem um mtodo chamado run, cujo cdigo pode estar em execuo concorrente. Uma das maneiras de se definir uma classe cujos objetos podem ter mtodos concorrentes  definir uma"
                ,victor, 1, 1, 5, 5,
                Arrays.asList("classe abstrata run e, em seguida, definir subclasses run. ", "subclasse da classe predefinida thread, que fornece suporte para o mtodo run.", "exceo para o mtodo run.", "exceo para o mtodo main.", "exceo com interrupo para o mtodo run ativo, sempre que um novo mtodo run for instanciado."),
                ints(1));

        exameJava1.novaQuestao("Dois ou mais processos que possuem acesso livre aos mesmos dados podem colidir. Assim, um programador Java que est implementando Threads, ao detectar que um mtodo  uma seo crtica, deve proteg-lo. Uma instruo do Java que poder ser utilizada para proteger o mtodo :"
                ,victor, 1, 1, 5, 5,
                Arrays.asList("abstract.", "final.", "native.", "static.", "synchronized."),
                ints(4));

        exameJava1.novaQuestao("Para declarar uma constante chamada SIZE do tipo inteiro e com valor 10 no Java, podemos utilizar a construo: "
                ,victor, 1, 1, 5, 5,
                Arrays.asList("static extend integer SIZE = 10;", "static final int SIZE = 10;", "this extend integer SIZE := 10;", "this final int SIZE :=10;", "void final int SIZE = 10;"),
                ints(1));

        exameJava1.novaQuestao("Um programador, ao elaborar um programa, est utilizando instrues try para realizar o tratamento de excees. Para cada try que for inserido, dever ser includo pelo menos um: "
                ,victor, 1, 1, 5, 5,
                Arrays.asList("catch ou continue.", "catch ou finally.", "continue ou finally.", "continue ou raise.", "finally ou raise."),
                ints(1));

        exameJava1.novaQuestao("Assinale a opo que apresenta dois pacotes da API do Java utilizados para construir aplicaes com interface grfica. "
                ,victor, 1, 1, 5, 5,
                Arrays.asList("AWT e JRE.", "AWT e Swing.", "JRE e JVM.", "JRE e Swing.", "JVM e Swing."),
                ints(1));

        exameJava1.novaQuestao("Em Java, os mtodos podem apresentar uma srie de caractersticas definidas a partir de palavras-chave utilizadas " +
                "na sua definio. A palavra chave 'public' indica que o mtodo  acessvel onde sua classe for e a palavra-chave 'static' " +
                "especifica que o mtodo pertence  classe como um todo e no a uma instncia especfica. Assinale a opo que NO apresenta uma " +
                "palavra-chave que pode ser utilizada na definio de um mtodo."
                ,victor, 1, 1, 5, 5,
                Arrays.asList("abstract", "finally", "native", "void", "abort"),
                ints(1));

        exameJava1.novaQuestao("Se o mtodo alg receber como parmetros, respectivamente, os valores numricos 100,0, 0,1 e 4, ele retornar o valor: "
                ,victor, 1, 1, 5, 5,
                Arrays.asList("41", "42", "43", "44", "45"),
                ints(2));

        exameJava1.novaQuestao("Sobre a declarao e uso de classes, mtodos e atributos no Java,  correto afirmar que:"
                ,victor, 1, 1, 5, 5,
                Arrays.asList("em uma mesma classe pode-se declarar dois mtodos privados que apresentam o mesmo nome.", "em um mtodo de uma classe filha, a clusula this  utilizada para acessar um atributo da classe me.", "uma classe filha somente pode sobrepor um mtodo ou atributo da classe me se ele for pblico.", "uma classe abstrata pode ser implementada por uma classe concreta atravs da instruo implements.", "os corpos dos mtodos das interfaces so codificados para garantir que as classes que as utilizam sigam o mesmo padro de comunicao."),
                ints(0));

        examePort1.novaQuestao("Nicolau Maquiavel, em 1513, na Itlia renascentista, escreveu:\n" +
                "Um prncipe no pode observar todas as coisas a que so obrigados os homens considerados bons, sendo " +
                "freqentemente forado, para manter o governo, a agir contra a caridade, a f, a humanidade, a religio. " +
                "(...) O prncipe no precisa possuir todas as qualidades (ser piedoso, fiel, humano, ntegro e religioso), " +
                "bastando que aparente possu-las. Um prncipe, se possvel, no deve se afastar do bem, mas deve saber " +
                "entrar para o mal, se a isso estiver obrigado. \n" +
                "Adaptado de Nicolau Maquiavel. O Prncipe.\n\n" +
                "Indique qual das afirmaes est claramente expressa no texto:"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("Os homens considerados bons so os nicos aptos a governar.", "O prncipe deve observar os preceitos da moral crista medieval.", "Fidelidade, humanidade, integridade e religiosidade so qualidades indispensveis ao governante.", "O prncipe deve sempre fazer o mal, para manter o governo.", "A aparncia de ter qualidades  mais til ao governante do que possu-las."),
                ints(4));

        examePort1.novaQuestao("Seu xito (de Hitler) foi possvel pelo caos e (pela) desintegrao do governo alemo que se seguiram  crise " +
                "econmica de 1929 e foi resultado da complacncia poltica de conservadores e comunistas para com o " +
                "\"fenmeno grotesco e transitrio\" do nazismo (...).Mas o nazismo foi tambm produto do passado, ainda que no " +
                "um inevitvel produto, pela conjuno de uma srie de fatores de natureza diversa: entre eles o autoritarismo, o " +
                "militarismo, o racismo, o fracasso da revoluo democrtica de 1848, a derrota na Primeira Guerra " +
                "Mundial, a hiperinflao dos primeiros anos 1920, a j referida crise econmica aberta em 1929. \n" +
                "Adaptado de Boris Fausto. Folha de So Paulo, 11/12/2007.\n\n" +
                "A partir do texto do historiador Boris Fausto, pode-se afirmar: "
                ,pedro, 3, 3, 5, 5,
                Arrays.asList("O nazismo foi um movimento idealizado exclusivamente por Hitler.", "A crise de 1929 provocou o caos e a desintegrao do governo alemo.", "A fracassada revoluo democrtica de 1848  apontada como causa remota do nazismo.", "A Alemanha ficou imune aos efeitos da Primeira Guerra Mundial.", "O racismo explica, em parte, a ascenso do nazismo."),
                ints(1, 2, 4));

        examePort1.novaQuestao("Trabalho escravo ou escravido por dvida  uma forma de escravido que consiste na privao da liberdade " +
                "de uma pessoa (ou grupo), que fica obrigada a trabalhar para pagar uma dvida que o empregador alega ter sido " +
                "contrada no momento da contratao. Essa forma de escravido j existia no Brasil, quando era preponderante a " +
                "escravido de negros africanos que os transformava legalmente em propriedade dos seus senhores. As leis " +
                "abolicionistas no se referiram  escravido por dvida. Na atualidade, pelo artigo 149 do Cdigo Penal Brasileiro, o " +
                "conceito de reduo de pessoas  condio de escravos foi ampliado de modo a incluir tambm os casos de situao " +
                "degradante e de jornadas de trabalho excessivas. \n" +
                "Adaptado de Neide Estergi. A luta contra o trabalho escravo, 2007. \n\n" +
                "Com base no texto, considere as afirmaes abaixo e selecione a(s) correta(s): "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("O escravo africano era propriedade de seus senhores no perodo anterior  Abolio.", "O trabalho escravo foi extinto, em todas as suas formas, com a Lei urea.", "A escravido de negros africanos no  a nica modalidade de trabalho escravo na histria do Brasil.", "A privao da liberdade de uma pessoa, sob a alegao de dvida contrada no momento do contrato de trabalho, no  uma modalidade de escravido.", "As jornadas excessivas e a situao degradante de trabalho so consideradas formas de escravido pela legislao brasileira atual."),
                ints(0, 2, 4));

        examePort1.novaQuestao("A luta pelo desarmamento nuclear, pelo fim da Guerra Fria e pela paz serviu de inspirao, a partir da " +
                "dcada de 1960, para as chamadas msicas de protesto que, com diferentes referncias ideolgicas, tornaram " +
                "mundialmente conhecidas certas canes dos Beatles, Rolling Stones, Ramones, Sex Pistols etc. No Brasil, " +
                "tivemos fenmeno semelhante. 'Como  difcil acordar calado'  um dos versos de Clice, composio de Chico " +
                "Buarque de Holanda e Gilberto Gil, que explora o duplo sentido causado pela sonoridade de seu ttulo. \n" +
                "Composta em 1973, quando o pas estava sob o regime militar, a msica se refere"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("ao milagre econmico brasileiro.", " anistia ampla, geral e irrestrita.", "ao combate ao uso de drogas.", " campanha pelas diretas j.", " falta de liberdade de expresso."),
                ints(4));

        examePort1.novaQuestao("Eu amo a rua. Esse sentimento de natureza toda ntima no vos seria revelado por mim se no julgasse, e " +
                "razes no tivesse para julgar, que este amor assim absoluto e assim exagerado  partilhado por todos vs. " +
                "Ns somos irmos, ns nos sentimos parecidos e iguais; nas cidades, nas aldeias, nos povoados, no porque " +
                "soframos, com a dor e os desprazeres, a lei e a polcia, mas porque nos une, nivela e agremia o amor da rua.  " +
                "este mesmo o sentimento imperturbvel e indissolvel, o nico que, como a prpria vida, resiste s idades e s " +
                "pocas. Tudo se transforma, tudo varia o amor, o dio, o egosmo. Hoje  mais amargo o riso, mais dolorosa a " +
                "ironia. Os sculos passam, deslizam, levando as coisas fteis e os acontecimentos notveis. S persiste e fica, " +
                "legado das geraes cada vez maior, o amor da rua. \n" +
                "Joo do Rio. A alma encantadora das ruas. \n\n" +
                "No texto, observa-se que o narrador se: "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("equipara ao leitor, por meio de sentimentos diversos como o amor, o dio e o egosmo.", "distancia do leitor, porque o amor  rua, assim como o dio e o egosmo,  passageiro.", "identifica com o leitor, por meio de um sentimento perene, que  o amor  rua.", "aproxima do leitor, por meio de sentimentos duradouros como o amor  rua e o dio  polcia.", "afasta do leitor, porque, ao contrrio deste, valoriza ascoisas fteis."),
                ints(2));

        examePort1.novaQuestao("Artistas, costureiras, soldadores e desenhistas manejam ferro, madeira, isopor e tecido. No galpo do boi " +
                "Garantido, o do corao vermelho, todos se esmeram (nunca usam o verbo caprichar) para preparar um " +
                "espetculo que supere o do rival. No ano passado, foi o Caprichoso, o da estrela azul, o ganhador da disputa de " +
                "bois-bumb do famoso Festival de Parintins, que todo final de junho atrai cerca de cem mil pessoas para a doce ilha " +
                "situada na margem direita do rio Amazonas. No curral da torcida caprichosa, alegoristas, passistas e percussionistas " +
                "preferem no dizer que uma nova vitria est garantida. Dizem, sim, com todas as letras, que est assegurada. \n" +
                "Fernanda Pompeu. Caprichada e garantida.\n\n" +
                "De acordo com o texto, a escolha das palavras 'esmeram' e 'assegurada'  motivada pelo: "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("despreparo dos habitantes de Parintins.", "antagonismo entre os dois grupos.", "desejo de falar difcil.", "entrosamento entre as duas equipes.", "sentido irnico contido nesses dois termos."),
                ints(1));

        examePort1.novaQuestao("Assim se explicam a minha estada debaixo da janela de Capitu e a passagem de um cavaleiro, um dandy, " +
                "como ento dizamos. Montava um belo cavalo alazo, firme na sela, rdea na mo esquerda, a direita  cinta, " +
                "botas de verniz, figura e postura esbeltas: a cara no me era desconhecida. Tinham passado outros, e ainda outros " +
                "viriam atrs; todos iam s suas namoradas. Era uso do tempo namorar a cavalo. Rel Alencar: Porque um " +
                "estudante (dizia um dos seus personagens de teatro de 1858) no pode estar sem estas duas coisas, um cavalo e " +
                "uma namorada. Rel lvares de Azevedo. Uma das suas poesias  destinada a contar (1851) que residia em " +
                "Catumbi, e, para ver a namorada no Catete, alugara um cavalo por trs mil-ris... \n" +
                "Machado de Assis. Dom Casmurro. \n\n" +
                "As formas verbais 'Tinham passado' e viriam traduzem idia, respectivamente, de anterioridade e de posterioridade em relao ao fato expresso pela palavra: "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("explicam.", "estada.", "passagem.", "dizamos.", "montava."),
                ints(2));

        examePort1.novaQuestao("Assim se explicam a minha estada debaixo da janela de Capitu e a passagem de um cavaleiro, um dandy, " +
                "como ento dizamos. Montava um belo cavalo alazo, firme na sela, rdea na mo esquerda, a direita  cinta, " +
                "botas de verniz, figura e postura esbeltas: a cara no me era desconhecida. Tinham passado outros, e ainda outros " +
                "viriam atrs; todos iam s suas namoradas. Era uso do tempo namorar a cavalo. Rel Alencar: Porque um " +
                "estudante (dizia um dos seus personagens de teatro de 1858) no pode estar sem estas duas coisas, um cavalo e " +
                "uma namorada. Rel lvares de Azevedo. Uma das suas poesias  destinada a contar (1851) que residia em " +
                "Catumbi, e, para ver a namorada no Catete, alugara um cavalo por trs mil-ris... \n" +
                "Machado de Assis. Dom Casmurro. \n\n" +
                "Com a frase 'como ento dizamos', o narrador tem por objetivo, principalmente, "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("comentar um uso lingstico de poca anterior ao presente da narrao.", "criticar o uso de um estrangeirismo que cara em desuso.", "marcar o uso da primeira pessoa do plural.", "registrar a passagem do cavaleiro diante da janela de Capitu.", "condenar o modo como se falava no passado."),
                ints(0));

        examePort1.novaQuestao("A Idade Mdia europia  inseparvel da civilizao islmica j que consiste precisamente na convivncia, ao " +
                "mesmo tempo positiva e negativa, do cristianismo e do islamismo, sobre uma rea comum impregnada pela cultura greco-romana. \n" +
                "Jos Ortega y Gasset (1883-1955). \n\n" +
                "O texto acima permite afirmar que, na Europa ocidental medieval,"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("formou-se uma civilizao complementar  islmica, pois ambas tiveram um mesmo ponto de partida.", "originou-se uma civilizao menos complexa que a islmica devido  predominncia da cultura germnica.", "desenvolveu-se uma civilizao que se beneficiou tanto da herana greco-romana quanto da islmica.", "cristalizou-se uma civilizao marcada pela flexibilidade religiosa e tolerncia cultural.", "criou-se uma civilizao sem dinamismo, em virtude de sua dependncia de Bizncio e do Islo."),
                ints(2));

        examePort1.novaQuestao("Vestindo gua, s sado o cimo do pescoo, o burrinho tinha de se enqueixar para o alto, a salvar tambm de fora " +
                "o focinho. Uma peitada. Outro tacar de patas. Chu-a! Chu-a... ruge o rio, como chuva deitada no cho. " +
                "Nenhuma pressa! Outra remada, vagarosa. No fim de tudo, tem o ptio, com os cochos, muito milho, na " +
                "Fazenda; e depois o pasto: sombra, capim e sossego... Nenhuma pressa. Aqui, por ora, este poo doido, que " +
                "barulha como um fogo, e faz medo, no  novo: tudo  ruim e uma s coisa, no caminho: como os homens e os " +
                "seus modos, costumeira confuso.  s fechar os olhos. Como sempre. Outra passada, na massa fria. E ir sem " +
                "af,  voga surda, amigo da gua, bem com o escuro, filho do fundo, poupando foras para o fim. Nada mais, nada " +
                "de graa; nem um arranco, fora de hora. Assim. \n" +
                "Joo Guimares Rosa. O burrinho pedrs, Sagarana. \n\n" +
                "Como exemplos da expressividade sonora presente neste excerto, podemos citar a onomatopia, em Chu-a! Chu-a..., e a fuso de onomatopia com aliterao, em: "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("vestindo gua.", "ruge o rio.", "poo doido.", "filho do fundo.", "fora de hora."),
                ints(1));

        exameAll1.novaQuestao("Um aquecedor eltrico  mergulhado em um recipiente com gua a 10 C e, cinco minutos depois, a " +
                "gua comea a ferver a 100 C. Se o aquecedor no for desligado, toda a gua ir evaporar e o aquecedor ser danificado. " +
                "Considerando o momento em que a gua comea a ferver, a evaporao de toda a gua ocorrer em um intervalo de aproximadamente"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("5 minutos.","10 minutos.","15 minutos.","20 minutos.","25 minutos."),
                ints(4));

        exameAll1.novaQuestao("Sabendo que os anos bissextos so os mltiplos de 4 e que o primeiro dia de 2007 foi segunda-feira, o prximo " +
                "ano a comear tambm em uma segunda-feira ser: "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("2012","2014","2016","2018","2020"),
                ints(3));

        exameAll1.novaQuestao("Um lotao possui trs bancos para passageiros, cada um com trs lugares, e deve transportar os trs " +
                "membros da famlia Sousa, o casal Lcia e Mauro e mais quatro pessoas. Alm disso, \n" +
                "I. a famlia Sousa quer ocupar um mesmo banco; \n" +
                "II. Lcia e Mauro querem sentar-se lado a lado. \n\n" +
                "Nessas condies, o nmero de maneiras distintas de dispor os nove passageiros no lotao  igual a "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("928","1152","1828","2412","3456"),
                ints(4));

        exameAll1.novaQuestao("Na atualidade, praticamente todos os dirigentes polticos, no Brasil e no mundo, dizem-se defensores de " +
                "padres democrticos e de valores republicanos. Na Antigidade, tais padres e valores conheceram o auge, " +
                "tanto na democracia ateniense, quanto na repblica romana, quando predominaram "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("a liberdade e o individualismo.","a liberdade e o individualismo.","a demagogia e o populismo.","o consenso e o respeito  privacidade.","a tolerncia religiosa e o direito civil."),
                ints(1));

        exameAll1.novaQuestao("Nos sculos XIV e XV, a Itlia foi a regio mais rica e influente da Europa. Isso ocorreu devido "
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("iniciativa pioneira na busca do caminho martimo para as ndias.","centralizao precoce do poder monrquico nessa regio.","ausncia completa de relaes feudais em todo o seu territrio.","neutralidade da pennsula itlica frente  guerra generalizada na Europa.","combinao de desenvolvimento comercial com pujana artstica."),
                ints(4));

        exameAll1.novaQuestao("Em novembro de 1807, a famlia real portuguesa deixou Lisboa e, em maro de 1808, chegou ao Rio de Janeiro. O acontecimento pode ser visto como"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("incapacidade dos Braganas de resistirem  presso da Espanha para impedir a anexao de Portugal.","ato desesperado do Prncipe Regente, pressionado pela rainha-me, Dona Maria I.","execuo de um velho projeto de mudana do centro poltico do Imprio portugus, invocado em pocas de crise.","culminncia de uma discusso popular sobre a neutralidade de Portugal com relao  guerra anglofrancesa.","exigncia diplomtica apresentada por Napoleo Bonaparte, ento primeiro cnsul da Frana."),
                ints(2));

        exameAll1.novaQuestao("No Chile, a lei no serve para outra coisa a no ser produzir a anarquia e a ausncia de sanes [...] Se eu, " +
                "por exemplo, prendo um indivduo que sei que est tramando uma conspirao [contra o governo], violo a lei. " +
                "Maldita lei ento que no deixa o brao do governo proceder livremente no momento oportuno. [...] De minha " +
                "parte, sei dizer que, com lei ou sem ela, essa senhora que chamam de Constituio tem que ser violada quando as " +
                "circunstncias so extremas. \n" +
                "Carta de Diego Portales, ministro chileno, em 1834. \n\n" +
                "Nesse texto, Portales est defendendo uma viso"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("liberal, que privilegia o respeito s leis e  justia.","aristocrtica, que valoriza o regime monrquico.","federalista, que salvaguarda os interesses das provncias.","elitista, que defende os direitos do indivduo.","autoritria, que garante a ordem acima de tudo."),
                ints(4));

        exameAll1.novaQuestao("As estruturas presentes em uma clula vegetal,porm ausentes em uma bactria, so:"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("cloroplastos, lisossomos, ncleo e membrana plasmtica.","vacolos, cromossomos, lisossomos e ribossomos.","complexo golgiense, membrana plasmtica, mitocndrias e ncleo.","cloroplastos, mitocndrias, ncleo e retculo endoplasmtico.","cloroplastos, complexo golgiense, mitocndrias e ribossomos."),
                ints(3));

        exameAll1.novaQuestao("Indique a alternativa que lista somente doenas que tm artrpodes como transmissores ou hospedeiros intermedirios do agente causador:"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("amarelo, doena de Chagas, esquistossomose e tenase.","dengue, esquistossomose, febre amarela e malria.","amarelo, doena de Chagas, filariose e malria.","dengue, febre amarela, filariose e malria.","dengue, febre amarela, filariose e tenase."),
                ints(3));

        exameAll1.novaQuestao("Um argumento correto que pode ser usado para apoiar a idia de que os vrus so seres vivos  o de que eles"
                ,pedro, 1, 1, 5, 5,
                Arrays.asList("no dependem do hospedeiro para a reproduo.","possuem nmero de genes semelhante ao dos organismos multicelulares.","utilizam o mesmo cdigo gentico das outras formas de vida.","sintetizam carboidratos e lipdios, independentemente do hospedeiro.","sintetizam suas protenas independentemente do hospedeiro."),
                ints(2));

        exameHisto1.novaQuestao("Alexandre desembarca l onde foi fundada a atual cidade de Alexandria. Pareceu-lhe que o lugar era muito " +
                "bonito para fundar uma cidade e que ela iria prosperar. A vontade de colocar mos  obra fez com que ele prprio traasse " +
                "o plano da cidade, o local da gora, dos santurios da deusa egpcia sis, dos deuses gregos e do muro externo. \n" +
                "Flvio Arriano. Anabasis Alexandri (sc. I d.C.). \n\n" +
                "Desse trecho de Arriano, sobre a fundao de Alexandria,  possvel depreender "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("o significado do helenismo, caracterizado pela fuso da cultura grega com a egpcia e as do Oriente Mdio.", "a incorporao do processo de urbanizao egpcio, para efetivar o domnio de Alexandre na regio.", "a implantao dos princpios fundamentais da democracia ateniense e do helenismo no Egito.", "a permanncia da racionalidade urbana egpcia na organizao de cidades no Imprio helnico.", "o impacto da arquitetura e da religio dos egpcios, na Grcia, aps as conquistas de Alexandre."),
                ints(0));

        exameHisto1.novaQuestao("Da armada dependem as colnias, das colnias depende o comrcio, do comrcio, a capacidade de um " +
                "Estado manter exrcitos numerosos, aumentar a sua populao e tornar possveis as mais gloriosas e teis empresas. \n" +
                "Essa afirmao do duque de Choiseul (1719-1785) expressa bem a natureza e o carter do "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("liberalismo.", "feudalismo.", "mercantilismo.", "escravismo.", "corporativismo."),
                ints(2));

        exameHisto1.novaQuestao("A criao, em territrio brasileiro, de gado e de muares (mulas e burros), na poca da colonizao " +
                "portuguesa, caracterizou-se por"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("ser independente das demais atividades econmicas voltadas para a exportao.", "ser responsvel pelo surgimento de uma nova classe de proprietrios que se opunham  escravido.", "ter estimulado a exportao de carne para a metrpole e a importao de escravos africanos.", "ter-se desenvolvido, em funo do mercado interno, em diferentes reas no interior da colnia.", "ter realizado os projetos da Coroa portuguesa para intensificar o povoamento do interior da colnia."),
                ints(3));

        exameHisto1.novaQuestao("Nossas instituies vacilam, o cidado vive receoso, assustado; o governo consome o tempo em vs " +
                "recomendaes... O vulco da anarquia ameaa devorar o Imprio: aplicai a tempo o remdio. \n" +
                "Padre Antonio Feij, em 1836. \n\n" +
                "Essa reflexo pode ser explicada como uma reao : "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("revogao da Constituio de 1824, que fornecia os instrumentos adequados  manuteno da ordem.", "interveno armada brasileira na Argentina, que causou grandes distrbios nas fronteiras.", "disputa pelo poder entre So Paulo, centro econmico importante, e Rio de Janeiro, sede do governo.", "crise decorrente do declnio da produo cafeeira, que produziu descontentamento entre proprietrios rurais.", "ecloso de rebelies regionais, entre elas, a Cabanagem no Par e a Farroupilha no sul do pas."),
                ints(4));

        exameHisto1.novaQuestao("Uma casa dividida contra si mesma no subsistir. Acredito que esse governo, meio escravista e meio livre, " +
                "no poder durar para sempre. No espero que a Unio se dissolva; no espero que a casa caia. Mas espero que " +
                "deixe de ser dividida. Ela se transformar s numa coisa ou s na outra. \n" +
                "Abraham Lincoln, em 1858. \n\n" +
                "Esse texto expressa a: "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("posio poltica autoritria do presidente Lincoln.", "perspectiva dos representantes do sul dos EUA.", "proposta de Lincoln para abolir a escravido.", "proposta de Lincoln para abolir a escravido.", "preocupao de Lincoln com uma possvel guerra civil."),
                ints(4));

        exameHisto1.novaQuestao("A imigrao de italianos (desde o final do sculo XIX) e a de japoneses (desde o incio do sculo XX), no Brasil, " +
                "esto associadas a "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("uma poltica nacional de atrao de mo-de-obra para a lavoura e s transformaes sociais provocadas pelo capitalismo na Itlia e no Japo.", "interesses geopolticos do governo brasileiro e s crises industrial e poltica pelas quais passavam a Itlia e o Japo.", "uma demanda de mo-de-obra para a indstria e s presses polticas dos fazendeiros do sudeste do pas.", "uma poltica nacional de fomento demogrfico e a um acordo com a Itlia e o Japo para exportao de matrias-primas.", "acordos internacionais que proibiram o trfico de escravos e  poltica interna de embranquecimento da populao brasileira."),
                ints(0));

        exameHisto1.novaQuestao("Em um balano sobre a Primeira Repblica no Brasil, Jlio de Mesquita Filho escreveu: \n" +
                "... a poltica se orienta no mais pela vontade popular livremente manifesta, mas pelos caprichos de um nmero limitado " +
                "de indivduos sob cuja proteo se acolhem todos quantos pretendem um lugar nas assemblias estaduais e federais. \n" +
                "A crise nacional, 1925. \n\n" +
                "De acordo com o texto, o autor "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("critica a autonomia excessiva do poder legislativo.", "prope limites ao federalismo.", "defende o regime parlamentarista.", "critica o poder oligrquico.", "defende a supremacia poltica do sul do pas."),
                ints(3));

        exameHisto1.novaQuestao("Em trs momentos importantes da histria europia Revolues de 1830-1848, Primeira Guerra Mundial de " +
                "1914-1918, e movimentos fascista e nazista das dcadas de 1920-1930 nota-se a presena de uma fora " +
                "ideolgica comum a todos esses acontecimentos. \n\n" +
                "Trata-se do"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("totalitarismo.", "nacionalismo.", "imperialismo.", "conservadorismo.", "socialismo."),
                ints(1));

        exameHisto1.novaQuestao("Existem semelhanas entre as ditaduras militares brasileira (1964-1985), argentina (1976-1983), uruguaia " +
                "(1973-1985) e chilena (1973-1990).\n\n" +
                "Todas elas"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("receberam amplo apoio internacional tanto dos Estados Unidos quanto da Europa Ocidental.", "combateram um inimigo comum, os grupos esquerdistas, recorrendo a mtodos violentos.", "tiveram forte sustentao social interna, especialmente dos partidos polticos organizados.", "apoiaram-se em idias populistas para justificar a manuteno da ordem.", "defenderam programas econmicos nacionalistas, promovendo o desenvolvimento industrial de seus pases."),
                ints(4));

        exameHisto1.novaQuestao("O modelo poltico/econmico adotado por Portugal no Brasil colnia foi"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("Popularizao.", "Extrativista.", "Sem fins lucrativos", "Socialista.", "Nenhum das alternativas."),
                ints(1));

        exameGeo1.novaQuestao("As previses catastrofistas dos 'neomalthusianos' sobre o crescimento demogrfico e sua presso sobre os " +
                "recursos naturais no se confirmaram, notadamente, porque"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("o processo de globalizao permitiu o acesso voluntrio e universal a meios contraceptivos eficazes, impactando, sobretudo, os pases em desenvolvimento.", "a nova onda de 'revoluo verde', propiciada pela introduo dos transgnicos, afastou a ameaa de fome epidmica nos pases mais pobres.", "as aes governamentais e a urbanizao implicaram forte queda nas taxas de natalidade, exceto em pases muulmanos e da frica Subsaariana, entre outros.", "o estilo de vida consumista, maior responsvel pela degradao dos recursos naturais, vem sendo superado desde a Conferncia Rio-92.", "os fluxos migratrios de pases pobres para aqueles ricos que tm crescimento vegetativo negativo compensaram a presso sobre os recursos naturais."),
                ints(2));

        exameGeo1.novaQuestao("Considere duas hipteses sobre a origem do homem americano, que teria ocorrido h mais de 10.000 anos. \n" +
                "Hipteses: \n" +
                "I. Migraes oriundas da sia, passando pelo estreito de Bering. \n" +
                "II. Migraes oriundas da Polinsia, via Oceano Pacfico. \n\n" +
                "Quanto a fatos geogrficos que as sustentam,  correto afirmar que a hiptese"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("I apia-se em uma grande elevao do nvel do mar, fato que tambm teria aumentado a navegabilidade nessa regio.", "I explica-se pela ocorrncia de glaciaes que, diminuindo o nvel do mar, teriam unido o Alasca  Sibria, por terra.", "II associa-se  ocorrncia de inmeras glaciaes que teriam melhorado a navegabilidade, justificando a vinda pelas ilhas do Pacfico.", "II relaciona-se  existncia de diversas ilhas no Pacfico, que teriam se ligado muitas vezes por terra, durante as glaciaes.", "II refere-se  ocorrncia de correntes marinhas equatoriais e de glaciaes, que teriam facilitado a navegao no Pacfico."),
                ints(1));

        exameGeo1.novaQuestao("Uma das caractersticas atuais do processo de globalizao  a exigncia, cada vez maior, de fluidez de " +
                "informaes e mercadorias, ou, em essncia, do prprio capital. Tal exigncia tem conduzido os pases  " +
                "reestruturao de seus sistemas de circulao. Nesse sentido, no Estado brasileiro, nos ltimos anos,"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("priorizou-se o transporte pblico urbano, com a ampliao do nmero de linhas do Metropolitano em todas as capitais dos Estados.", "houve uma ampla recuperao da malha ferroviria, com a construo de novos trechos, a exemplo da Transnordestina.", "privilegiou-se o sistema de cabotagem, valorizando-se o transporte de passageiros pelo territrio nacional e interligando as reas costeiras do pas.", "priorizou-se o transporte hidrovirio, voltado  exportao de gros, conforme atestam as hidrovias Tiet-Paran e do Rio So Francisco.", "intensificou-se a modernizao do sistema porturio, incluindo a construo de portos como os de Sepetiba (RJ) e Pecm (CE)."),
                ints(4));

        exameGeo1.novaQuestao("O Brasil  uma Repblica Federativa que apresenta muitas desigualdades regionais. Confrontando-se dois " +
                "aspectos ' a igualdade jurdica entre os Estados-membros e as disparidades econmicas entre as regies' pode-se afirmar que"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("o desequilbrio econmico regional vem sendo, ao menos parcialmente, atenuado pelo menor nmero de representantes do Sudeste no Congresso Nacional, em comparao aos do Norte e Nordeste.", "a regio Norte  a menos representada no Congresso Nacional, fato notvel principalmente no Senado, derivando da uma situao de desigualdade perante as demais regies.", "a regio Sul goza de ampla maioria de representao no Congresso Nacional, o que lhe tem permitido obter vantagens na redistribuio dos repasses federais.", "princpio da igualdade, garantido pelo nmero fixo de senadores por Estado, permite uma distribuio equilibrada dos repasses federais, entre as diferentes regies do pas.", "os Estados nordestinos, apesar de sua pouca representatividade no Congresso, vm assumindo liderana na definio das polticas monetria e cambial no pas."),
                ints(0));

        exameGeo1.novaQuestao("Considere as afirmaes abaixo, relativas  ocupao do Centro-Oeste brasileiro, onde originalmente predominava a vegetao do Cerrado e aponte a(s) correta(s)."
                ,paula, 2, 2, 5, 5,
                Arrays.asList("A vegetao nativa do Cerrado encontra-se, hoje, quase completamente dizimada, principalmente em funo do processo de expanso da fronteira agrcola, que avana agora na Amaznia.", "O desenvolvimento de tecnologia apropriada permitiu que o problema da baixa fertilidade natural dos solos no Centro-Oeste fosse, em grande parte, resolvido.", "O modelo fundirio predominante na ocupao da rea do Cerrado imitou aquele vigente no oeste gacho, de onde saiu a maioria dos migrantes que chegaram ao Centro-Oeste nos ltimos 30 anos."),
                ints(0, 1));

        exameGeo1.novaQuestao("No municpio de So Paulo, em uma regio vizinha a cinco cidades em expanso e prxima  rodovia Raposo " +
                "Tavares, existe uma grande rea de remanescentes originais da Mata Atlntica. Essa regio foi recentemente " +
                "protegida por lei, com a criao de uma rea de preservao ambiental, o Parque Tizo. O parque abriga " +
                "espcies ameaadas de extino, como a araponga, o pica-pau rei e muitas espcies de plantas. Dentre os " +
                "objetivos das polticas de preservao ambiental, indique qual deles pode ser atendido com a criao do Parque Tizo."
                ,paula, 1, 1, 5, 5,
                Arrays.asList("Preservar a biodiversidade da regio.", "Diminuir as causas do efeito estufa .", "Diminuir a contaminao ambiental.", "Preservar a comunidade local.", "Diminuir os efeitos do aquecimento global."),
                ints(0));

        exameGeo1.novaQuestao("O Canal do Panam foi construdo em 1914 pelos Estados Unidos, que controlaram sua administrao por " +
                "quase um sculo e s devolveram a soberania da rea aos panamenhos em 1999. A atual ampliao do canal " +
                "visa permitir o trfego de navios de maior porte, atualmente utilizados com mais freqncia, em " +
                "decorrncia do aumento do volume do comrcio internacional nas ltimas dcadas. Mais de 100 rotas de " +
                "transporte martimo passam pelo Canal do Panam, sendo uma das principais aquela que liga o Extremo " +
                "Oriente  costa leste dos Estados Unidos. \n\n" +
                "Com base em seus conhecimentos e no texto indique a alternativa correta:"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("O Canal do Panam reduziu sensivelmente as distncias a serem percorridas nas rotas martimas entre as costas leste e oeste dos EUA.", "As rotas mais beneficiadas com a construo do Canal do Panam so as que ligam a Europa e a frica Ocidental  costa leste dos EUA.", "A ampliao do Canal do Panam no deve apresentar um aumento significativo no trfego do canal, j que os navios de maior porte no so utilizados intensamente nos dias de hoje.", "O Canal do Panam apresenta importncia estratgica e militar para os EUA, apesar da pouca relevncia econmica referente s rotas comerciais martimas.", "O Canal do Panam no teve um papel significativo na circulao martima internacional nem na estratgia de defesa militar dos EUA."),
                ints(0));

        exameGeo1.novaQuestao("Com base nos seus conhecimentos sobre o comrcio internacional, assinale a alternativa correta:"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("Os produtos agropecurios apresentavam, em 2005, participao majoritria nas exportaes mundiais, em comparao com os demais grupos de produtos.", "O crescimento do comrcio internacional atingiu sobretudo os pases menos desenvolvidos, pois neles se localiza a maior oferta de servios e maior produo industrial de alta tecnologia.", "O comrcio internacional cresceu intensamente nas ltimas dcadas, com peso significativo dos produtos industrializados e dos servios.", "A participao dos combustveis nas exportaes mundiais, em 2005, foi muito influenciada pelas cotaes internacionais dos preos do petrleo e do lcool.", "Os produtos industrializados apresentavam, em 2005, maior participao no comrcio internacional, em funo das elevadas barreiras alfandegrias impostas pela Organizao Mundial do Comrcio."),
                ints(2));

        exameGeo1.novaQuestao("O sal estala sob os ps como se fosse neve, em um campo estril da regio oeste do Uzbequisto. 'H 30 " +
                "anos, aqui se plantava algodo, diz um agricultor de 61 anos que viveu perto da cidade de Khujayli por toda a vida. 'Agora,  uma plancie salgada'.\n" +
                "'Quando voc v todo esse sal, logo se deixa tomar por pensamentos sombrios e obscuros', ele afirmou, " +
                "explicando que o sal  o que resta quando a gua evapora devido  irrigao intensa. 'Nada cresce em terras salgadas.  como estar em p sobre uma sepultura'. \n" +
                "The New York Times, 17/06/2008. \n\n"+
                "De acordo com o texto, o agricultor diz ter pensamentos sombrios e obscuros quando v o sal porque "
                ,paula, 1, 1, 5, 5,
                Arrays.asList("o Uzbequisto fez parte da Unio Sovitica e representa grande rea de desastre artificial.", "os rios do Uzbequisto foram desviados e a terra foi violentada por muitos anos.", "a terra ficou salgada e nada cresce em terras salgadas.", "o Mar de Aral tornou-se um grande lago salgado e perdeu mais de metade de sua rea.", "o Uzbequisto  o nico lugar em que o agricultor viveu e ele j tem 61 anos."),
                ints(2));

        exameGeo1.novaQuestao("Com base nos seus conhecimentos sobre as migraes internacionais, assinale a alternativa INCORRETA:"
                ,paula, 1, 1, 5, 5,
                Arrays.asList("Alguns pases europeus e os EUA apresentam um significativo nmero de cidades com grandes contingentes de populao imigrante.", "A Unio Europia e os EUA tm estabelecido rigorosos controles de imigrao, sobretudo em relao aos imigrantes ilegais vindos do Canad.", "Os pases americanos, em particular os EUA, receberam um nmero significativo de imigrantes europeus at meados do sculo passado.", "A Europa ocidental caracteriza-se atualmente por ser um plo de atrao de imigrantes, o que tem levado a uma regulamentao mais severa no controle da imigrao.", "O Oriente Mdio, a Austrlia e a China apresentam algumas cidades com grandes contingentes de populao imigrante."),
                ints(1));

        exameIdiota.novaQuestao("Se voc fosse um preto negro ou um negro preto, de que cor voc seria?",
                victor, 2, 4, 6, 8,
                Arrays.asList("Azul", "Verde", "Laranja com bolinhas amarelas", "Preto nego sangue bo", "Rosas so vermelhas", "Violetas so azuis", "Bem... ento... pois !", "Black power", "Nego", "Escuro"),
                ints(3, 7, 8, 9));

        exameIdiota.novaQuestao("Qual  a arco-cosecante da tangente hiperblica do coseno da tua me tendendo ao infinito?",
                pedro, 2, 3, 4, 5,
                Arrays.asList("No sei", "No quero saber", "Tenho raiva de quem sabe", "sqrt(?)", "-cos(-sen(integral x^(x)dx))", "42"),
                ints(0, 1, 2));

        exameIdiota.novaQuestao("Qual  a cor do cavalo branco de Napoleo?",
                paula, 1, 1, 6, 6,
                Arrays.asList("Preto", "Branco", "Marrom", "Cor de burro quando foge", "Verde-amarelo com bolinhas lils", "42"),
                ints(0));

        exameIdiota.novaQuestao("Com quantos paus de plstico se faz uma canoa de pedra?",
                paula, 4, 4, 6, 8,
                Arrays.asList("0", "1", "2", "?r", "42", "Tua me", "Tua av", "e=mc", "Mata um corinthiano e transforma ele em canoa"),
                ints(4, 5, 6, 8));

        fazerProva(victor.iniciarProva(exameJava1));
        fazerProva(victor.iniciarProva(examePort1));
        fazerProva(victor.iniciarProva(exameAll1));
        fazerProva(victor.iniciarProva(exameHisto1));
        fazerProva(victor.iniciarProva(exameGeo1));

        fazerProva(pedro.iniciarProva(exameJava1));
        fazerProva(pedro.iniciarProva(examePort1));
        fazerProva(pedro.iniciarProva(exameAll1));
        fazerProva(pedro.iniciarProva(exameHisto1));
        fazerProva(pedro.iniciarProva(exameGeo1));

        fazerProva(paula.iniciarProva(exameJava1));
        fazerProva(paula.iniciarProva(examePort1));
        fazerProva(paula.iniciarProva(exameAll1));
        fazerProva(paula.iniciarProva(exameHisto1));
        fazerProva(paula.iniciarProva(exameGeo1));

        fazerProva(fernanda.iniciarProva(exameJava1));
        fazerProva(fernanda.iniciarProva(examePort1));
        fazerProva(fernanda.iniciarProva(exameAll1));
        fazerProva(fernanda.iniciarProva(exameHisto1));
        fazerProva(fernanda.iniciarProva(exameGeo1));
    }

    private static void criarTreinamentos() {
        Treinamento spam1 = Treinamento.novo("spam",
                "TORPEDO [SMS] NO CELULAR DE GRACA!\n"+
                "Est cansado de gastar dinheiro mandando mensagens para celular?\n" +
                "Pare com isso! Agora voc envia Torpedos SMS de GRAA para seus amigos!\n" +
                "visite:\n" +
                "www.torpedo-sms.tk\n");
        Treinamento spam2 = Treinamento.novo("spam",
                "LINDAS MENSAGENS\n" +
                "TELEMENSAGEM D'AMORE\n" +
                "Lindas mensagens para voc presentear, encantar,\n" +
                "emocionar, parabenizar, conquistar, ou surpreender\n" +
                "algum especial em qualquer ocasio.\n" +
                "Ligue agora: (11) 2211-2493\n");
        Treinamento spam3 = Treinamento.novo("spam",
                "Ganhe dinheiro pra navegar na Internet!\n" +
                "Clique aqui e saiba como!");
        Treinamento spam4 = Treinamento.novo("spam",
                "NOVIDADE!!!\n" +
                "Msica, Amizade, Paquera, Namoro e mto Mais!\n" +
                "Faa Amigos, encontre sua Alma Gmea\n" +
                "Salas com at 4 webcam's!");
        Treinamento spam5 = Treinamento.novo("spam",
                "faveladas do orkut, mais de 6000 fotos peladinhas\n" +
                "lique aqui para ver as imagens ! ! ! ");
        Treinamento spam6 = Treinamento.novo("spam",
                "Parabns\n\n" +
                "O seu perfil foi sorteado na loteria on-line do orkut.\n" +
                "Clique aqui para receber R$ 1.000.000,00 agora!!!!!!!");
        Treinamento spam7 = Treinamento.novo("spam",
                "Emagreci 20kg em 2 meses! (depoimento)\n" +
                "Ol! Tenho 30 anos, 1,65m e PESAVA 78kg. Engordei muito depois da minha 1gestao e por isso, perdi minha auto-estima e fiquei muito deprimida. Fui a vrios endocrinologistas e tomei diversos tipos de medicamentos e as melhores frmulas existentes no mercado. At em propaganda de emagrecedores da internet eu tentei e NADA disso resolveu, pois emagrecia um pouco e logo engordava tudo novamente.\n" +
                "J no sabia mais o que fazer, pois detesto dietas e ginstica e queria uma maneira fcil de emagrecer. At que reencontrei uma amiga de infncia q passou pela mesma situao que eu, ou seja, era obesa (1,63m e 91kg) e EMAGRECEU 35kg!!!Ela me mostrou fotos antigas qdo era gorda e quase nem acreditei, minha amiga agora est magra mesmo, linda, com auto-estima, namorado lindo e muito mais feliz. Fiquei doida, e perguntei pra ela o q ela fez. Ela me falou de um tratamento que adapta substncias em um diagnstico individual, fazendo o medicamento agir precisamente na necessidade de cada organismo,junto de componentes naturais que controlam o intestino, fazendo-o funcionar perfeitamente e substncias que ajudam a queimar gorduras localizadas (principalmente na rea do abdmen) e alm disso,ele quebra as molculas de gorduras dos alimentos, melhorando a qualidade de absoro deles evitando futuros problemas de colesterol, etc. Enfim, fiz o tratamento por 2 meses e consegui perder 20kg.  engordei mais aps a manuteno. O melhor de tudo  que posso comer o que quero sem ter medo de engordar, pois com este tratamento meu organismo metaboliza os alimentos de uma forma mais eficaz.\n" +
                "Bem, estou muuuito feliz mesmo. Quem quiser dicas ou saber mais sobre a minha histria de vitrias, entre em contato, me escrevam:samantadeouro@hotmail.com. Vamos trocar experincias, nos ajudar. Espero que escrevam aquelas que realmente precisam de ajuda e j no acreditam mais nas propagandas enganosas da internet, tv e outros.\n" +
                "Um beijo a todos e nunca desistam,\n" +
                "Fiquem com Deus. ");
        Treinamento spam8 = Treinamento.novo("spam",
                "*****Bate Papo Oficial ! - ChatAlegria\n" +
                "Chat Alegria Salas de Bate Papo\n" +
                "Est Cansado dos mesmos contatos do seu MSN !\n" +
                "Quer conhecer gente nova\n" +
                "Quer Conhecer Gente Bonita e Inteligente\n" +
                "Quer Fazer novos Amigos e quem sabe encontrar um Amor ??\n" +
                "Acesse j o Chat Alegria !!!\n" +
                "www . chatalegria . com . br\n" +
                "******Venha fazer novos amigos ******\n" +
                "***** Sucesso incomoda, ento nao se incomode se junte ao Chatalegria ");
        Treinamento spam9 = Treinamento.novo("spam",
                "JOGUE POKER E DISPUTE UM CARRO E MAIS US$ 50.000 EM PRMIOS DE GRAA!\n" +
                "Participe do Desafio Universitrio de Texas Holdem e ganhe crditos de graa para entrar na disputa por mais de US$ 70.000 em prmios!\n" +
                "TOTALMENTE GRTIS! Sem truques e sem complicaes\n" +
                "Qualquer jogador universitrio pode participar. As inscries so gratuitas e j esto abertas. Quanto antes voc se inscrever, mais chances voc tem de ganhar!\n" +
                "Acesse www universidadedopoker com e saiba tudo sobre o Desafio!");
        Treinamento spam10 = Treinamento.novo("spam",
                "Desconto no Viagra !!!!\n" +
                "Melhore suas relaes sexuais sem problemas!!!\n" +
                "Disk agora ou clique no link abaixo!\n" +
                "Link do Viagra");
        Treinamento spam11 = Treinamento.novo("spam",
                "Assista a mais de 10.000 canais\n" +
                "de TV e RDIO!!\n" +
                "TV ONLINE SEM ASSINATURA NO SEU COMPUTADOR!\n" +
                "NOVA VERSO ONLINE TV NO COMPUTADOR\n" +
                "ASSISTA TODOS OS CANAIS EM QUALQUER PARTE DO MUNDO\n" +
                "NO PRECISA INSTALAR NENHUM PROGRAMA EM SEU COMPUTADOR\n" +
                "ENVIAREMOS UMA SENHA EM SEU EMAIL PARA ASSISTIR A TV AO VIVO\n" +
                "Assista Globo, SBT, Record, Ao Vivo em Tempo Real!\n" +
                "FCIL ACESSO\n" +
                "TECNOLOGIA DIGITAL VIA INTERNET\n" +
                "PROGRAMAO COMPLETA\n" +
                "TVs DO MUNDO INTEIRO\n" +
                "SUPER FCIL DE USAR\n" +
                "NENHUM APARELHO EXTRA PARA ASSISTIR TV NO COMPUTADOR\n" +
                "ABSOLUTAMENTE SEM PAGAMENTOS MENSAIS\n" +
                "ENVIAMOS A SENHA PARA TODO DO BRASIL\n" +
                "Sucesso de Vendas em todo Brasil!\n" +
                "MILHARES DE CLIENTES SATISFEITOS. SEJA VOC O PRXIMO!\n" +
                "Acesse nosso site agora!\n" +
                "www.superguiadetv.com.br");
        Treinamento spam12 = Treinamento.novo("spam",
                "ASSISTA A MAIS DE 3000 CANAIS DE TV NA TELA DO SEU COMPUTADOR\n" +
                "Sem pagar mensalidade\n" +
                "Informaes: http://www.lovethewayyouloveme.com/ \n" +
                "Saiba como assistir canais do Brasil e do exterior atravs do seu PC\n" +
                "Canais de Esporte\n" +
                "ABC Sports,Euro Sports,\n" +
                ",Band Sports,BBC Sports,RAI Sports, ESPN\n" +
                "Fox Sports,Online Racing...\n" +
                "Canais de Jornalismo\n" +
                "CBS News Live, ABC News,BBC News,Bloomberg Tv USA,\n" +
                ",Al Jazeera,Cuba Vision\n" +
                "Band News,Tv Azteca,TV Chile,RAI...\n" +
                "Canais de Filme\n" +
                "Arts Movie,Fox5,Cinemax,Adventures Movie Chan,\n" +
                ", HBO,ETV Hollywood\n" +
                "Old Movie...\n" +
                "Canais de Shows,Msicas\n" +
                "All Music,\n" +
                ",Party Tv,Ton Top Tv,Soleil Tv,Music Plus Tv,A1 Tv,Africa Hit\n" +
                "Future Tv,Tv Rock, MTV News,Cybertika...\n" +
                "Canais de Variedades\n" +
                "Arts Channel,Archeologi Channel,\n" +
                ",National Geographic,Canal Latino,Metropolis Tv\n" +
                "Mexiquense,Museum Tv,Discovery Animal Planet,\n" +
                ",Beach Tv\n" +
                "E! Entertainment,Fashion Tv,Nasa Tv...\n" +
                "Canais Religiosos\n" +
                "Good Tv, Islan Channel,Discovery Islan Tv,Miracle Channel,Vatican Tv,Al\n" +
                "Karma Tv\n" +
                "..\n" +
                "Canais Nacionais\n" +
                "SBT,Clima Tempo,Bandeirantes,Tv Amazon Sat,Tv Litoral,Bloomberg,Rede TV\n" +
                ",\n" +
                ",Tv Super Gospel,Canal do Boi,RTVE Cultura,Tv Educativa\n" +
                "Cano Nova,Rede Opnio de Tv,Canal 21,Capital Tv,Tv Senado,Agro Canal\n" +
                ",Mix Tv,Tv Fortaleza,Tv Braslia,CBS,Tv Universitria\n" +
                "Tv Aparecida,\n" +
                ",Rede Gnesis,Tv Cidade...");
        Treinamento spam13 = Treinamento.novo("spam",
                "APRESENTAMOS A VOC UMA CHANCE NICA DE CRESCIMENTO\n" +
                "CURSO TOTAL\n" +
                "Os melhores cursos do Brasil agora ao seu alcance\n" +
                "Super cursos em DVD's que iro ajud-lo a passar em qualquer\n" +
                "CONCURSO, PROVA ou VESTIBULAR!\n" +
                "Curso 1\n" +
                "Portugus\n" +
                "Curso 2\n" +
                "Ingls\n" +
                "Curso 3\n" +
                "Matemtica\n" +
                "DESCONTO\n" +
                "Curso 4\n" +
                "Qumica\n" +
                "SUPER DESCONTO\n" +
                "Curso 5\n" +
                "Fsica!\n" +
                "PROMOO\n" +
                "INVISTA EM SEU FUTURO!\n" +
                "CLIQUE AQUI AGORA E\n" +
                "ADQUIRA O SEU!");
        Treinamento spam14 = Treinamento.novo("spam",
                "DIETA PARA LEIGOS\n" +
                "APRENDA 10 REGRAS INFALVEIS DE DIETA E EMAGRECIMENTO\n" +
                "VOC PRECISA EMAGRECER?\n" +
                "Algumas pessoas precisam perder 8kg, outras precisam perder 30kg.\n" +
                "Ns sabemos que voc est aqui porque quer perder peso... e a boa notcia  que nossa dieta vai ajudar voc independente da quantidade de peso que voc precisa perder.\n" +
                "Por qu? Porque nosso sistema de Dieta vai continuar funcionando dia aps dia... e  por isso que ele  to valioso. Aps 11 dias voc pode continuar usando para emagrecer o quanto desejar.\n" +
                "O valor do Livro Virtual Dieta para Leigos  de R$ 59,00.\n" +
                "Lembrando que so livros virtuais, voc ter acesso a eles atravs da internet.\n" +
                "Aps a confirmao de pagamento enviamos para seu email os dados de acesso com login e senha!\n" +
                "VOC RECEBER UM LINK, COM LOGIN E SENHA PARA TER ACESSO AO\n" +
                "LIVRO VIRTUAL DIETA PARA LEIGOS COM O SEGUINTE CONTEDO:\n" +
                "Cardpios Online (cardpios para voc fazer dieta por 11 dias)\n" +
                 "As 10 REGRAS para Perder Peso\n" +
                 "Emagrea 4 KG a cada 11 dias\n" +
                 "Voc vai aprender como PARAR DE RETER GUA\n" +
                 "Voc vai aprender COMO PEDIR COMIDA NO RESTAURANTE para estimular a\n" +
                 "queima de gordura enquanto come\n" +
                 "Voc vai aprender como beber lcool ENQUANTO QUEIMA GORDURA\n" +
                 "Voc vai aprender o que comprar na feira para ESTIMULAR O EMAGRECIMENTO\n" +
                 "de toda sua famlia\n" +
                 "Voc vai aprender como COMER MAIS DE 3 VEZES AO DIA\n" +
                 "Voc vai aprender como COMER  NOITE para nunca sentir fome na hora de dormir\n" +
                 "Voc vai aprender por que voc pode perder peso MESMO COM GENTICA RUIM\n" +
                 "Voc vai aprender como CONTINUAR MAGRO(A) PARA SEMPRE!\n" +
                 "H uma seo especial no manual detalhando como proceder DEPOIS de conquistar\n" +
                "o corpo desejado, para manter o seu novo peso e medida\n" +
                "Experimente no nosso programa de queima de gorduras acelerado para EMAGRECER\n" +
                "Por apenas R$ 59,00\n" +
                "Faa seu pedido e fique em forma!");
        Treinamento spam15 = Treinamento.novo("spam",
                "Caso no esteja visualizando este e-mail,clique aqui\n" +
                "Este e-mail  enviado de acordo com o Guia de Boas Maneiras\n" +
                "para e-mail marketing da ABEMD - Associao Brasileira de Marketing Direto.\n" +
                "No responda essa mensagem - Caso no queira receber nossos e-mails, envie uma mensagem para retirar@calamares.com.br .");
        Treinamento spam16 = Treinamento.novo("spam",
                "Revista Abril\n" +
                "Observaes:\n" +
                "Oferta vlida at 27/06/2009 e para pagamento com carto de crdito ou por dbito em conta.\n" +
                "Voc receber o primeiro exemplar em at 3 semanas.\n" +
                "Se preferir, faa seu pedido por telefone. Ligue para 0800-7754770 e, na Grande So Paulo, 3347-2121.\n" +
                "Ao ligar, informe o cdigo de oferta KFRQ.\n" +
                "Reservamo-nos o direito de corrigir eventuais erros de divulgao neste e-mail marketing.");
        Treinamento spam17 = Treinamento.novo("spam",
                "Quer aumentar o tamanho do seu pnis??\n" +
                "Precisa de viagra???\n" +
                "Mulher peladada??\n" +
                "Bunda??\n" +
                "Sexo??\n" +
                "Clique aqui!!!\n" +
                "No vizualiza a imagem? Clique aqui");
        Treinamento spam18 = Treinamento.novo("spam",
                "*** NOTCIA IMPORTANTE: ***\n" +
                "ACABA DE CHEGAR AO MERCADO O SENSACIONAL E REVOLUCIANRIO KIT DE CDS E DVDS COM AS MAIS BELAS " +
                "E GOSTOSAS MULHERES QUE VOC J VIU NA VIDA!!!!! SO MAIS DE 1.000 VDEOS E 20.000 FOTOS SENSACIONAIS DE " +
                "LOIRAS, MORENAS, NEGRAS, MULATAS E ASITICAS PARA FAZER VOC GOZAR. ANAL, VAGINAL, ORAL, GRUPAL, 69, LSBICAS E TRAVESTIS!\n" +
                "LIGUE AGORA MESMO E RECEBA UM DESCONTO ESPECIAL NA PROMOO (11) 3131-3131\n" +
                "FAA AGORA O SEU PEDIDO!\n" +
                "(11) 3131-3131");
        Treinamento spam19 = Treinamento.novo("spam",
                "PIPA EM CASA.COM\n" +
                "IMAGINE VOC COMPRAR PELA INTERNET SUAS PIPAS E RECEB-LAS NA SUA CASA!!!\n" +
                "CHEGOU A REVOLUO EM VENDAS DE PIPAS E ACESSRIOS PELA INTERNET.\n" +
                "Acesse agora o site www.pipaemcasa.com e faa o seu pedido!");
        Treinamento spam20 = Treinamento.novo("spam",
                "Oiiiiiiiiii\n" +
                "Olha as fotos suas q coloquei nessa comunidade\n" +
                "ela chama GATOS E GATAS la tem 3 fotos suaS\n" +
                "para concorrer a capa.\n" +
                "www.gatas.com\\gatos \n" +
                "Da um olhada la e vote OK??");
        Treinamento spam21 = Treinamento.novo("spam",
                "Oi, depois olha essa comunidade que estou moderando\n" +
                "ela chama TopVipLuz la tem 2 fotos sua\n" +
                "para concorrer a capa. Da um olhada la e vote\n" +
                "nesse link tem as fotos\n" +
                "viagra");
        Treinamento spam22 = Treinamento.novo("spam",
                "Super promoo especial.\n" +
                "Clique aqui agora e preencha o cupom para concorrer a vrios prmios e a uma casa no valor de R$ 50.000,00!\n" +
                "Hoje  o seu dia de sorte, clique aqui e ganhe prmios on line!");
        Treinamento spam23 = Treinamento.novo("spam",
                "NESTA SEXTA , O ESPECIAL NOKIA TRENDS, MSICA E ARTE ELETRNICA EM UM EVENTO S. SEXTA AGORA A MEIA NOITE NO FERVOTRONIK S PODIA SER 107FM\n" +
                "Saibam mais em:\n" +
                "radiofm107.com.br/fervotronik / nokiatrends.com.br");
        Treinamento spam24 = Treinamento.novo("spam",
                "Viagra para voc e toda a sua famlia!!!!\n" +
                "Clique aqui agora!!!\n" +
                "Ou ligue!!\n" +
                "Ou acesse ao site!!!\n" +
                "D a bunda!");
        Treinamento spam25 = Treinamento.novo("spam",
                "COMUNIDADE DA BANDA\n" +
                "entra a pra nos ajudar!!!e tmb pra ficar por dentro das novidades da banda!\n" +
                "http://www.orkut.com/Community.aspx?cmm=22395414\n" +
                "Vlwww!\n" +
                "11/20/06\n" +
                "zaza:\n" +
                "por sua culpa agora todo mundo me chama de COR DE CAIXA!!!\n" +
                "uuhahuahuhuahua!!\n" +
                ":)\n" +
                "Entra ae!! Ou clique no link!");

        Treinamento msg1 = Treinamento.novo("msg",
                "opa\n" +
                "velho o nego nao me pago\n" +
                "ele fico de passa em casa esses\n" +
                "dias\n" +
                "se ele nao der um jeito de paga\n" +
                "eu vo vender uma pedalera q peguei\n" +
                "como pagamento de servico\n" +
                "maus\n" +
                "abracos");
        Treinamento msg2 = Treinamento.novo("msg",
                "oii....como vc ta?\n" +
                "me ligue sempre que precisar....\n" +
                "gosto muito de vc!!!!vc  muito especial!!!!\n" +
                "bjs");
        Treinamento msg3 = Treinamento.novo("msg",
                "e ae mlk!!!\n" +
                "po...vc sumiu!!!\n" +
                "cara...vai te churrar esse ano d novo l na FEA..\n" +
                "vamo??\n" +
                "bate um futiba...um churras....\n" +
                "da um toque pra mim!!\n" +
                "falow cara!\n" +
                "aparece l hein!!!!");
        Treinamento msg4 = Treinamento.novo("msg",
                "ola sr tranqueira!!!\n" +
                "eu ja soube da chegada da natalinha.\n" +
                "no fim de semana nao pude ir. vou ver se vou agora durante a semana.\n" +
                "ja comprei ate o presente. mas ando mal do brao e vou pra curitiba na quarta a noite. vamos ver se da tempo essa semana ou vou na que vem.\n" +
                "beijos");
        Treinamento msg5 = Treinamento.novo("msg",
                "Hoje nao teve, e nao sei se vai ter amanha!\n" +
                "Pois , agora vou ficar forte igual que nem voc! =)\n" +
                "Abraos!");
        Treinamento msg6 = Treinamento.novo("msg",
                "Oi Sergio,\n" +
                "Aquela questo do exame est errada cara. Da uma olhada l.\n" +
                "T+\n" +
                "Victor");
        Treinamento msg7 = Treinamento.novo("msg",
                "Fala Victor,\n" +
                "Seguinte: a questo 2 est confusa do exame de java. Verifica l.\n" +
                "Abraos,\n" +
                "Pedro");
        Treinamento msg8 = Treinamento.novo("msg",
                "Seja bem vindo ao Simiquiz Paula\n" +
                "Qualquer dvida mande uma mensagem privada para os administradores. Esperamos que goste do site!\n" +
                "Atenciosamente,\n" +
                "Equipe do Simuquiz");
        Treinamento msg9 = Treinamento.novo("msg",
                "Ol Tereza. Foi muito bom ver vc e sua trupe. Espero que tenham tido uma boa viagem. Bjs. Telma e as crionas mandam lembranas.");
        Treinamento msg10 = Treinamento.novo("msg",
                "Td bem?\n" +
                "O Emerson ter que viajar para Curitiba AMANH, dia 15/08, irei com ele,  viajem de um dia, voltaremos no sbado.\n" +
                "Queriamos te encontrar!\n" +
                "Olha, se for possvel, ser que poderamos dormir de sexta para sbado em sua casa?\n" +
                "Nossos telefones so: 1176238466 e 11 93654340.\n" +
                "Aguardo resposta.\n" +
                "Tentei falar com vc pelos seus cels mas no consegui, estavam desligados!\n" +
                "Um beijo grande.\n" +
                "Ana");
        Treinamento msg11 = Treinamento.novo("msg",
                "Ju!!! Que saudades de voc linda!!!\n" +
                "Como est a nova vida em SP...J se adaptou ...\n" +
                "Mande notcias...e quando vier pra c, venha nos ver!!!\n" +
                "Beijos.");
        Treinamento msg12 = Treinamento.novo("msg",
                "Oi Lgia!!! Td bem?\n" +
                "Feliz 2009 pra vc!!\n" +
                "Que este ano possamos renovar nosso esprito e fazer um dele melhor que o ano passado!! Felicidades!!!!\n" +
                "Beijos!!!");
        Treinamento msg13 = Treinamento.novo("msg",
                "OI Lygia!!!\n" +
                "Parabns, muitas felicidades, muitos anos de vida !!!\n" +
                "PS: E o mestrado em que p que t?\n" +
                "Bjo ");
        Treinamento msg14 = Treinamento.novo("msg",
                "Boa pergunta...\n" +
                "Eu no sei se o Fernando foi erro de escrivo ou se  uma descendncia totalmente diferente de SOUSA. A minha linha, at onde sei,  Claudia.\n" +
                "Vou dar uma pesquisada ae\n" +
                "T+ ");
        Treinamento msg15 = Treinamento.novo("msg",
                "Ol para todos desta comunidade, achei muito interessante o significado do sobrenome dvida questo que  o meu, apesar de no ter entendido muito.");
        Treinamento msg16 = Treinamento.novo("msg",
                "Oi pessoal! Gostaria de saber quem tem um livro inteiro por aqui e no composto uma parte pela me e outra do pai.");
        Treinamento msg17 = Treinamento.novo("msg",
                "Um Lopes de Souza na Alemanha\n" +
                "Eu morei em Floripa, nasci em Curitiba, meu pai \"Lopes de Souza\" nasceu em So Francisco do Sul - SC e eu estou morando agora na Alemanha, levando a famlia de volta pro continente velho.");
        Treinamento msg18 = Treinamento.novo("msg",
                "Ol,\n" +
                "Gostei muito do seu exame. Aprendi muita coisa e revi vrios conceitos. Parabns pelo trabalho realizado.\n" +
                "Abraos,\n" +
                "Paula");
        Treinamento msg19 = Treinamento.novo("msg",
                "E ae Pedro td bm!?\n" +
                "Num foi pela Bel num!! Alias num flo c sua irm faz mto tmepo!! Cm ela tah!? Manda bju!!\n" +
                "Intaum t achei na comunidade do Sitio!! srs!!\n" +
                "Faz tempo q n t vejo msm!! Cm c tah!?\n" +
                "Bjos");
        Treinamento msg20 = Treinamento.novo("msg",
                "Dudes...parabens pelo site em primeiro lugar!\n" +
                "To fazendo um tcc na area de criptografia, e preciso implementar um software. O sistema que eu escolhi foi o rsa, mas nao manjo quase nada de programao. Alguem pode me indicar um site que eu ache um algoritmo pronto para o netbeans?? Obrigado!!");
        Treinamento msg21 = Treinamento.novo("msg",
                "Obrigada pela pacincia thingo... muitas coisas eu j havia entendido, e algumas outras ficaram mais claras para mim... ");
        Treinamento msg22 = Treinamento.novo("msg",
                "Frdi advogaObrigada pela pacincia thingo... muitas coisas eu j havia entendido, e algumas outras ficaram mais claras para mim... ndo em causa prpria, rs. Parabns pelo aniversrio, companheiro, e parabns a Irlanda por esse inventivo feriado. Se por aqui fssemos fazer algum dia especial em homenagem ao personagem de um livro, quem mereceria tal honraria?");
        Treinamento msg23 = Treinamento.novo("msg",
                "Boa Tarde Pessoal!\n" +
                "E o seguinte, meu pc liga uso ele normal, mas depois de umas 3 ou 4 horas de uso ou menos ele desliga e liga sozinho so que nao da mais video, desligo ele completo e ligo novamente tudo roda normal placa de video, cooler processador, hd etc mas nao da video!!!!!\n" +
                "Ai espero uns 20 ou 30 min e ligo ele ai da video de novo, e fica mais um tempo depois volta a contecer tudo de novo!!!!\n" +
                "Ja fiz todos procedimentos, ja tirei memos e limpei com borracha, placa de video tirei e limpei, dei clear na mobo, enfim, ja desmontei ele completo e montei novamente, e nada, estou achando que pode ser mobo mas nao tenho certeza pois nao tenho peas para fazer um teste mais profundo, mas placa de video ja testei em outro e funfou normal, memos tb, fonte ta normal!\n" +
                "Se algum tiver alguma ideia e quiser tentar dar uma ajudinha eu agradeo!!!\n" +
                "Obrigado a todos!\n" +
                "Abrao!!!");
        Treinamento msg24 = Treinamento.novo("msg",
                "Sim, achei que fosse temp mas nao , temp do procesador em idle e 26 e placa mae30 placa de video 35 a minha placa mae nao tem video onbord ela e off, e ja testei outra placa de video nela e da o mesmo deifeito a minha 8800gts coloquei em outro pc e funfa normal, por isso estou achando que e placa mae mesmo, pois as temp estao normais, placa de video ok, memoria ok, fonte ok, estou para comprar outra mb ai testou e volto a postar aqui para vcs pois pode ajudar outras pessoas!\n" +
                "Obrigado pela coperao de todos em tentar ajudar por isso nao saio desse forum\n" +
                "Abrao a todos!");
        Treinamento msg25 = Treinamento.novo("msg",
                "Eu acho que tudo isso faz sentido. Com 15, 16 anos, se encontra o diabo por toda parte,\n" +
                "mas numa concentrao infinitamente maior numa Jose Culo como esta.");
    }
}
