/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.param;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.type.Type;

public class DynamicFilterParameterSpecification
implements ParameterSpecification {
    private final String filterName;
    private final String parameterName;
    private final Type definedParameterType;
    private final int queryParameterPosition;

    public DynamicFilterParameterSpecification(String filterName, String parameterName, Type definedParameterType, int queryParameterPosition) {
        this.filterName = filterName;
        this.parameterName = parameterName;
        this.definedParameterType = definedParameterType;
        this.queryParameterPosition = queryParameterPosition;
    }

    public int bind(PreparedStatement statement, QueryParameters qp, SessionImplementor session, int position) throws SQLException {
        Object value = qp.getFilteredPositionalParameterValues()[this.queryParameterPosition];
        this.definedParameterType.nullSafeSet(statement, value, position, session);
        return this.definedParameterType.getColumnSpan(session.getFactory());
    }

    public Type getExpectedType() {
        return this.definedParameterType;
    }

    public void setExpectedType(Type expectedType) {
    }

    public String renderDisplayInfo() {
        return "dynamic-filter={filterName=" + this.filterName + ",paramName=" + this.parameterName + "}";
    }
}

