/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;

public class DirectoryProviderHelper {
    private static Log log = LogFactory.getLog(DirectoryProviderHelper.class);

    public static String getSourceDirectory(String rootPropertyName, String relativePropertyName, String directoryProviderName, Properties properties) {
        String root = properties.getProperty(rootPropertyName);
        String relative = properties.getProperty(relativePropertyName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Guess source directory from " + rootPropertyName + " " + root != null ? root : ("<null> and " + relativePropertyName + " " + relative != null ? relative : "<null>")));
        }
        if (relative == null) {
            relative = directoryProviderName;
        }
        if (StringHelper.isEmpty((String)root)) {
            log.debug((Object)("No root directory, go with relative " + relative));
            File sourceFile = new File(relative);
            if (!sourceFile.exists()) {
                throw new SearchException("Unable to read source directory: " + relative);
            }
        } else {
            File rootDir = new File(root);
            if (!rootDir.exists()) {
                rootDir.mkdirs();
            } else if (!rootDir.isDirectory()) {
                throw new SearchException(rootPropertyName + " is not a directory");
            }
            if (rootDir.exists()) {
                File sourceFile = new File(root, relative);
                if (!sourceFile.exists()) {
                    sourceFile.mkdirs();
                }
                log.debug((Object)"Get directory from root + relative");
                try {
                    relative = sourceFile.getCanonicalPath();
                }
                catch (IOException e) {
                    throw new AssertionFailure("Unable to get canonical path: " + root + " + " + relative);
                }
            } else {
                throw new SearchException(rootPropertyName + " does not exist and cannot be created");
            }
        }
        return relative;
    }

    public static File determineIndexDir(String directoryProviderName, Properties properties) {
        String indexBase = properties.getProperty("indexBase", ".");
        String indexName = properties.getProperty("indexName", directoryProviderName);
        File indexDir = new File(indexBase);
        if (!indexDir.exists()) {
            indexDir.mkdirs();
        } else if (!indexDir.isDirectory()) {
            throw new SearchException(MessageFormat.format("Index directory is not a directory: {0}", indexBase));
        }
        if (!indexDir.canWrite()) {
            throw new SearchException("Cannot write into index directory: " + (indexDir.isAbsolute() ? indexBase : indexDir.getAbsolutePath()));
        }
        indexDir = new File(indexDir, indexName);
        return indexDir;
    }
}

