package web.service;


import static org.junit.Assert.assertEquals;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import persistence.model.Usuario;

public class UsuarioServiceImplTest {

	public static UsuarioService usuarioService;
	public static Usuario user;
	
	@Before
	public void setUp() throws Exception {			
		user = new Usuario("XPTO-QWE-1234-ABCD-DCBA-4321-EWQ-OTPX", "senha", "email");
		usuarioService = new UsuarioServiceImpl();
	}
	
	@After
	public void tearDown() {	
		EntityManagerFactory emf = Persistence.createEntityManagerFactory("Futebol");
		EntityManager em = emf.createEntityManager();
		
		em.getTransaction().begin();
		em.remove(user);
		em.getTransaction().commit();
		
		em.close();
	}

	@Test
	public void testAddUsuario() {
		usuarioService.addUsuario(user);
	}
	
	@Test(expected=java.lang.RuntimeException.class)
	public void testAddUsuarioWithoutLogin() {
		Usuario u = new Usuario(null, user.getSenha(), user.getEmail());
		usuarioService.addUsuario(u);	
	}
	
	@Test(expected=java.lang.RuntimeException.class)
	public void testAddUsuarioWithoutPass() {
		Usuario u = new Usuario(user.getLogin(), null, user.getEmail());
		usuarioService.addUsuario(u);	
	}
	
	@Test(expected=java.lang.RuntimeException.class)
	public void testAddUsuarioWithoutEmail() {
		Usuario u = new Usuario(user.getLogin(), user.getSenha(), null);
		usuarioService.addUsuario(u);	
	}
	
	@Test
	public void testFindByLoginAndSenha() {
		Usuario u = usuarioService.findByLoginAndSenha(user.getLogin(), user.getSenha());
		assertEquals(u.getEmail(), user.getEmail());
		assertEquals(u.getSenha(), user.getSenha());
		assertEquals(u.getLogin(), user.getLogin());
	}
	
	@Test
	public void testFindByLoginAndSenhaWithNullLogin() {
		Usuario u = usuarioService.findByLoginAndSenha(null, user.getSenha());
		assertEquals(u, null);
	}
	
	@Test
	public void testFindByLoginAndSenhaWithNullPass() {
		Usuario u = usuarioService.findByLoginAndSenha(user.getLogin(), null);
		assertEquals(u, null);
	}
	
	@Test
	public void testFindByLoginAndSenhaWithWrongPass() {
		Usuario u = usuarioService.findByLoginAndSenha(user.getLogin(), "wrong");
		assertEquals(u, null);
	}
	
	@Test
	public void testFindByLogin() {
		Usuario u = usuarioService.findByLogin(user.getLogin());
		assertEquals(u.getEmail(), user.getEmail());
		assertEquals(u.getSenha(), user.getSenha());
		assertEquals(u.getLogin(), user.getLogin());
	}

	@Test
	public void testFindByLoginWithInexistentLogin() {
		Usuario u = usuarioService.findByLogin("XPTO-QWE-1234-ABCD-DCBA-4321-EWQ-OTPX-2");
		assertEquals(u, null);
	}
	
	@Test
	public void testFindByLoginWithNullLogin() {
		Usuario u = usuarioService.findByLogin(null);
		assertEquals(u, null);
	}
	
	@Test
	public void testFindById() {
		Usuario u = usuarioService.findByLogin(user.getLogin());
		Usuario u2 = usuarioService.findById(u.getIdUsuario());
		assertEquals(u.getEmail(), u2.getEmail());
		assertEquals(u.getSenha(), u2.getSenha());
		assertEquals(u.getLogin(), u2.getLogin());
		assertEquals(u.getIdUsuario(), u2.getIdUsuario());
	}
}
