package web.action;


import java.io.File;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import servletunit.struts.MockStrutsTestCase;

public class AdicionaUsuarioActionTest extends MockStrutsTestCase {

	public AdicionaUsuarioActionTest(String testName) {
		super(testName);
	}
	
	@Before
	public void setUp() throws Exception {
		super.setUp();
		setContextDirectory(new File("src/main/webapp"));
	}

	@After
	public void tearDown() throws Exception {
		super.tearDown();
	}

	@Test
	public void testSuccessForward() {
	    setRequestPathInfo("/adicionaUsuario");
	    request.addParameter("textLogin", "login");
	    request.addParameter("textPassword", "senha");
	    request.addParameter("textEmail", "email");
	    actionPerform();
	    verifyForward("success");
	    verifyNoActionErrors();
	}
	
	@Test
	public void testErrorForwardWithoutLogin() {
		setRequestPathInfo("/adicionaUsuario");
		request.addParameter("textLogin", "");
		request.addParameter("textPassword", "senha");
		request.addParameter("textEmail", "email");
		actionPerform();
		verifyForward("error");
		verifyNoActionErrors();
	}
	
	@Test
	public void testErrorForwardWithoutPassword() {
	    setRequestPathInfo("/adicionaUsuario");
	    request.addParameter("textLogin", "login");
	    request.addParameter("textPassword", "");
	    request.addParameter("textEmail", "email");
	    actionPerform();
	    verifyForward("error");
	    verifyNoActionErrors();
	}
	
	@Test
	public void testErrorForwardWithoutEmail() {
	    setRequestPathInfo("/adicionaUsuario");
	    request.addParameter("textLogin", "login");
	    request.addParameter("textPassword", "senha");
	    request.addParameter("textEmail", "");
	    actionPerform();
	    verifyForward("error");
	    verifyNoActionErrors();
	}	
}
