package web.service;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

import persistence.model.Usuario;

public class UsuarioServiceImpl extends BaseService implements UsuarioService {

	public void addUsuario(Usuario usuario) {  
		EntityManager em = getEntityManager();
		
		em.getTransaction().begin();
		em.persist(usuario);		
		em.getTransaction().commit();
	}
	
	
	public Usuario findByLoginAndSenha(String login, String senha) {
		EntityManager em = getEntityManager();
		Query query = em.createQuery("SELECT u FROM Usuario u WHERE u.login= ?1 AND u.senha = ?2");
		
		query.setParameter(1, login);
		query.setParameter(2, senha);
		try {		
			Usuario usuario = (Usuario) query.getSingleResult();
			return usuario;
		} catch (NoResultException e) {
			return null;
		}
	}
	
	
	public Usuario findByLogin(String login) {
		EntityManager em = getEntityManager();
		
		Query query = em.createQuery("SELECT u FROM Usuario u WHERE u.login= ?1");
		
		query.setParameter(1, login);
		try {		
			Usuario usuario = (Usuario) query.getSingleResult();
			return usuario;
		} catch (NoResultException e) {
			return null;
		}
	}
	
	public Usuario findById(long id) {
		EntityManager em = getEntityManager();		
		return em.find(Usuario.class, id);
	}

}
