package web.service;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

import persistence.model.Avaliacao;

public class AvaliacaoServiceImpl extends BaseService implements
		AvaliacaoService {

	public void addAvaliacao(Avaliacao avaliacao) {
		
		EntityManager em = getEntityManager();
		
		em.getTransaction().begin();
		em.persist(avaliacao);		
		em.getTransaction().commit();

	}
	
	public boolean avaliacaoExists(int usuarioId, Long noticiaId) {		
		EntityManager em = getEntityManager();
		Query query = em.createQuery("SELECT a FROM Avaliacao a WHERE a.usuario.idUsuario= ?1 AND a.noticia.idNoticia = ?2");
		
		query.setParameter(1, usuarioId);
		query.setParameter(2, noticiaId);
		
		try {
			query.getSingleResult();
			return true;
		} catch(NoResultException e){
			return false;
		}
	}	
}
