package web.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import persistence.dao.DAOFactory;
import persistence.model.Assunto;
import persistence.model.Usuario;
import util.exception.ServiceException;
import util.forward.StrutsForward;
import web.service.AssuntoService;

public class NovaNoticiaAction extends Action {

	private static final long serialVersionUID = 5184319597780160246L;
	private List<String> errors;
	private AssuntoService assuntoService;
    
    public ActionForward execute(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response)
    throws Exception {
    	String forward = StrutsForward.EXCEPTION;
		Usuario usuario = (Usuario) request.getSession().getAttribute("Usuario");
		errors = new ArrayList<String>();

		try {
			if (usuario != null) {
				assuntoService = DAOFactory.getInstance().getDao(AssuntoService.class);
				List<Assunto> assuntos = assuntoService.getAllAssuntos();
				request.setAttribute("assuntos", assuntos);

				forward = StrutsForward.SUCCESS;
			}
			else {
				errors.add("Usurio no autenticado");
				request.setAttribute("errors", errors);
				forward = StrutsForward.NO_AUTHENTICATION;
			}
		}
		catch (Exception e) {
			request.setAttribute("exception", new ServiceException(e));
		}
		
		return mapping.findForward(forward);
	}
}
