package web.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import persistence.model.Usuario;
import util.forward.StrutsForward;

public class NovaAvaliacaoAction extends Action {

	private static final long serialVersionUID = 5184319597780160246L;
	private List<String> errors;
    
    public ActionForward execute(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response)
    throws Exception {
    	String forward;
		Usuario usuario = (Usuario) request.getSession().getAttribute("Usuario");
		errors = new ArrayList<String>();

		if (usuario != null) {
			forward = StrutsForward.SUCCESS;
		}
		else {
			errors.add("Usurio no autenticado");
			request.setAttribute("errors", errors);
			forward = StrutsForward.NO_AUTHENTICATION;
		}
		
		return mapping.findForward(forward);
	}
}
