package web.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import persistence.dao.DAOFactory;
import persistence.model.Noticia;
import persistence.model.Usuario;
import util.exception.ServiceException;
import util.forward.StrutsForward;
import web.service.NoticiaService;

public class LeNoticiaAction extends Action {

	private static final long serialVersionUID = 5184319597780160246L;
	private List<String> errors;
	private NoticiaService noticiaService;
    
    public ActionForward execute(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response)
    throws Exception {
    	String forward = StrutsForward.EXCEPTION;
		Usuario usuario = (Usuario) request.getSession().getAttribute("Usuario");
		errors = new ArrayList<String>();

		try {

			if (usuario != null) {
				noticiaService = DAOFactory.getInstance().getDao(NoticiaService.class);
				Noticia noticia = noticiaService.findByID(Long.parseLong(request.getParameter("noticiaId")));
				request.setAttribute("txtTitulo", noticia.getTitulo());
				request.setAttribute("txtTexto", noticia.getTexto());
				request.setAttribute("noticiaId", noticia.getIdNoticia());

				forward = StrutsForward.SUCCESS;
			}
			else {
				errors.add("Usurio no autenticado");
				request.setAttribute("errors", errors);
				forward = StrutsForward.NO_AUTHENTICATION;
			}
		}
		catch (Exception e) {
			request.setAttribute("exception", new ServiceException(e));
		}
		
		return mapping.findForward(forward);
	}
}
