package web.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import persistence.dao.DAOFactory;
import persistence.model.Usuario;
import util.exception.ServiceException;
import util.forward.StrutsForward;
import web.service.UsuarioService;

public class AdicionaUsuarioAction extends Action {

	private static final long serialVersionUID = 5184319597780160246L;
	private List<String> errors;
	private UsuarioService usuarioService;   
    
    public ActionForward execute(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response)
    throws Exception {
    	String forward = StrutsForward.EXCEPTION;
		String login = request.getParameter("textLogin");
		String senha = request.getParameter("textPassword");
		String email = request.getParameter("textEmail");

		try {
			usuarioService = DAOFactory.getInstance().getDao(UsuarioService.class);
			errors = new ArrayList<String>();

			validaUsuario(login, senha, email);

			if ( errors.size() == 0 ) {
				Usuario usuario = new Usuario(login, senha, email);
				usuarioService.addUsuario(usuario);
				forward = StrutsForward.SUCCESS;
			}
			else {
				request.setAttribute("errors", errors);
				forward = StrutsForward.ERROR;
			}
		}
		catch (Exception e) {
			request.setAttribute("exception", new ServiceException(e));
		}
		
		return mapping.findForward(forward);
	}
    
	private void validaUsuario(String login, String senha, String email) {				
		if ("".equals(login)) {
			errors.add("Login vazio.");
		}	
		else if(usuarioService.findByLogin(login) != null) 
		{
			errors.add("Login j� existe.");
		}	
		if ("".equals(senha)) {
			errors.add("Senha vazia.");
		}
		if ("".equals(email)) {
			errors.add("E-mail vazio.");
		}
	}
}
