package web.action;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import persistence.dao.DAOFactory;
import persistence.model.Contato;
import persistence.model.Usuario;
import util.exception.ServiceException;
import util.forward.StrutsForward;
import web.service.ContatoService;

public class AdicionaContatoAction extends Action {

	private static final long serialVersionUID = 5184319597780160246L;
	private List<String> errors;  
	private ContatoService contatoService;
    
    public ActionForward execute(ActionMapping mapping, ActionForm form,
    		HttpServletRequest request, HttpServletResponse response)
    throws Exception {
    	String forward = StrutsForward.EXCEPTION;
		String titulo = request.getParameter("textTitulo");
		String texto = request.getParameter("textTexto");
		Usuario usuario = null;
		
		try {
			contatoService = DAOFactory.getInstance().getDao(ContatoService.class);
			errors = new ArrayList<String>();
			validaUsuario(titulo, texto);

			if ( errors.size() == 0 ) {
				usuario = (Usuario) request.getSession().getAttribute("Usuario");

				if (usuario != null) {
					Contato contato = new Contato(usuario, titulo, texto);
					contatoService.addContato(contato);
					forward = StrutsForward.SUCCESS;
				}
				else {
					errors.add("Usurio no autenticado");
					request.setAttribute("errors", errors);
					forward = StrutsForward.NO_AUTHENTICATION;
				}
			}
			else {
				request.setAttribute("errors", errors);
				forward = StrutsForward.ERROR;
			}
		}
		catch (Exception e) {
			request.setAttribute("exception", new ServiceException(e));
		}
		
		return mapping.findForward(forward);
	}
    
	private void validaUsuario(String titulo, String texto) {				
		if ("".equals(titulo)) {
			errors.add("Ttulo vazio.");
		}	
		if ("".equals(texto)) {
			errors.add("Texto vazio.");
		}
	}
}
