package persistence.model;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;

@Entity
public class Noticia {

	private String titulo;
	private String texto;
	@ManyToOne
	private Usuario usuario;
	@ManyToOne
	private Assunto assunto;
	@OneToOne
	private Avaliacao avaliacao;
	@Id
	private long idNoticia;
	
	public Noticia(Usuario usuario, Assunto assunto, String titulo, String texto) {
		this.usuario = usuario;
		this.assunto = assunto;
		this.titulo = titulo;
		this.texto = texto;
	}
	public Noticia() {
		// TODO Auto-generated constructor stub
	}
	
	public String getTitulo() {
		return titulo;
	}
	public void setTitulo(String titulo) {
		this.titulo = titulo;
	}
	public String getTexto() {
		return texto;
	}
	public void setTexto(String texto) {
		this.texto = texto;
	}
	public Usuario getUsuario() {
		return usuario;
	}
	public void setUsuario(Usuario usuario) {
		this.usuario = usuario;
	}
	public Assunto getAssunto() {
		return assunto;
	}
	public void setAssunto(Assunto assunto) {
		this.assunto = assunto;
	}
	public Avaliacao getAvaliacao() {
		return avaliacao;
	}
	public void setAvaliacao(Avaliacao avalicao) {
		this.avaliacao = avalicao;
	}
	public long getIdNoticia() {
		return idNoticia;
	}
	public void setIdNoticia(long idNoticia) {
		this.idNoticia = idNoticia;
	}
	
	
}
