/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class WriterToUTF8
extends Writer {
    private static final boolean DEBUG_OUT = false;
    private final OutputStream m_os;

    public WriterToUTF8(OutputStream os) throws UnsupportedEncodingException {
        this.m_os = os;
    }

    public void write(int c) throws IOException {
        if (c < 128) {
            this.m_os.write(c);
        } else if (c < 2048) {
            this.m_os.write(192 + (c >> 6));
            this.m_os.write(128 + (c & 0x3F));
        } else {
            this.m_os.write(224 + (c >> 12));
            this.m_os.write(128 + (c >> 6 & 0x3F));
            this.m_os.write(128 + (c & 0x3F));
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        OutputStream os = this.m_os;
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void write(String s) throws IOException {
        int n = s.length();
        OutputStream os = this.m_os;
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                os.write(c);
            } else if (c < '\u0800') {
                os.write(192 + (c >> 6));
                os.write(128 + (c & 0x3F));
            } else {
                os.write(224 + (c >> 12));
                os.write(128 + (c >> 6 & 0x3F));
                os.write(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void flush() throws IOException {
        this.m_os.flush();
    }

    public void close() throws IOException {
        this.m_os.close();
    }

    public OutputStream getOutputStream() {
        return this.m_os;
    }
}

