#include "listaLigada.h"
#include <stdlib.h>

ListaLigada* novaListaLigada(int (*compara) (TIPO, TIPO)){
   ListaLigada* l = malloc(sizeof(ListaLigada));
   l->cabeca = malloc(sizeof(No));
   l->cabeca->prox = l->cabeca;
   l->compara = compara;
   return l;
}

void insereNoFim(ListaLigada* l, TIPO elemento) {
   No* no = malloc(sizeof(No));
   no->prox = l->cabeca->prox;
   l->cabeca->prox = no;
   l->cabeca->elemento = elemento;
   l->cabeca = no;
}

void insereNoInicio(ListaLigada* l, TIPO elemento) {
   No* no = malloc(sizeof(No));
   no->prox = l->cabeca->prox;
   l->cabeca->prox = no;
   no->elemento = elemento;
}

BOOLEAN removeElemento(ListaLigada* l, TIPO elemento) {
   No* no;
   No* removido;

   for(no = l->cabeca; no->prox != l->cabeca; no = no->prox) {
      if(l->compara(elemento, no->prox->elemento) == IGUAL) {
         removido = no->prox;
         no->prox = no->prox->prox;
         free(removido);
         return TRUE;
      }
   }

   return FALSE;
}

No* busca(ListaLigada* l, TIPO elemento) {
   No* no;

   for(no = l->cabeca->prox; no != l->cabeca; no = no->prox) {
      if(l->compara(elemento, no->elemento) == IGUAL) {
         return no;
      }
   }

   return NULL;
}

void removeNo(ListaLigada* l, No* removido) {
   No* no;

   for(no = l->cabeca; no->prox != l->cabeca; no = no->prox) {
      if(l->compara(removido->elemento, no->prox->elemento) == IGUAL) {
         no->prox = no->prox->prox;
         free(removido);
         break;
      }
   }
}

void mata(ListaLigada* l) {
   No* ant;
   No* atual;
   atual = l->cabeca->prox;

   while(atual != l->cabeca) {
      ant = atual;
      atual = atual->prox;
      free(ant);
   }

   free(l->cabeca);
   free(l);
}
