#include<stdio.h>
#include<stdlib.h>
#include<assert.h>
#include "fila.h"

#define MURO 'x'
#define LIVRE '-'
#define TACA 't'
#define VISITADO 'v'
#define GALINHADA 'g'
#define ROTA '.'

typedef struct Coordenada {
	int x, y;
	struct Coordenada* origem;
} Coordenada;

char** alocaMatriz(int n, int m);
Coordenada* novaCoordenada(int x, int y, Coordenada* origem);
void cade_a_galinhada(char** mapa, Coordenada* galinhada, int n, int m);
void imprimeRota(char** mapa, Coordenada* galinhada, int n, int m, Coordenada* c);
char** leMatriz(int* x, int* y, int* n, int* m);

char** alocaMatriz(int n, int m) {
   char** matriz = malloc(sizeof(char*) * n);
   int i;

   for(i = 0; i < n; i++) {
      matriz[i] = malloc(sizeof(char) * m);
   }

   return matriz;
}

Coordenada* novaCoordenada(int x, int y, Coordenada* origem) {
   Coordenada* c = malloc(sizeof(Coordenada));
   c->x = x;
   c->y = y;
   c->origem = origem;
   return c;
}

/*
 * "galinhada" corresponde aa coordenada do time que ainda nao tem estadio
 * ("n" * "m") eh o tamanho do "mapa"
 * "mapa" eh a matriz que representa o labirinto.
 */
void cade_a_galinhada(char** mapa, Coordenada* galinhada, int n, int m) {
   int i = 0;
   int posX[4]={0, 0,-1, 1};
   int posY[4]={1,-1, 0, 0};
   Fila* f = novaFila(n * m);
   Coordenada* atual;
   Coordenada* vizinho;
   insere(f, galinhada);

   while(!estaVazia(f)) {
      atual = retira(f);

      for(i = 0; i < 4; i++) {
         vizinho = novaCoordenada(atual->x + posX[i], atual->y + posY[i], atual);

         if(mapa[vizinho->x][vizinho->y] == TACA) {
            /* Achei!!! */
            /* imprime o caminho */
            imprimeRota(mapa, galinhada, n, m, vizinho);
            return;
         } else if(mapa[vizinho->x][vizinho->y] == LIVRE) {
            mapa[vizinho->x][vizinho->y] = VISITADO;
            insere(f, vizinho);
         }
      }
   }

   printf("daqui a 100 anos quem sabe?");
}

void imprimeRota(char** mapa, Coordenada* galinhada, int n, int m,  Coordenada* c) {
   int i, j;

   printf("\nA ROTA DAS GALINHAS NEGRAS\n");
   c = c->origem;

   while(c != galinhada) {
      mapa[c->x][c->y] = ROTA;
      c = c->origem;
   }

   mapa[galinhada->x][galinhada->y] = GALINHADA;

   for(i = 0; i < n; i++) {
      for(j = 0; j < m; j++) {
         if(mapa[i][j] == VISITADO) {
            printf("%c", LIVRE);
         } else {
            printf("%c", mapa[i][j]);
         }
      }

      printf("\n");
   }
}

char** leMatriz(int* x, int* y, int* n, int* m){
   int i, j;
   char** mapa;
   char c;
   scanf("%d %d ", n, m); /* no precisa de &, pois n e m j so ponteiros */
   mapa = alocaMatriz(*n, *m);

   for(i = 0; i < *n; i++) {
      for(j = 0; j < *m; j++) {
         scanf("%c ", &c);
         mapa[i][j] = c;
         printf("%c", mapa[i][j]);

         if(c == GALINHADA) {
            *x = i;
            *y = j;
         }
      }
      printf("\n");
   }

   return mapa;
}

int main() {
   char** mapa;
   int x, y, n, m;
   mapa = leMatriz(&x, &y, &n, &m);
   cade_a_galinhada(mapa, novaCoordenada(x, y, NULL), n, m);
   return 0;
}

