/* constantes para trabalhar com tipo "booleano" */
#define BOOLEAN int
#define TRUE 1
#define FALSE 0

#define TIPO void*

/*
 * Estrutura que representa uma fila (utiliza o
 * paradigma FIFO "first in first out").
 */
typedef struct Fila {
	int ini, fim;
	int capacidade;
	TIPO* fila;
} Fila;

/*
 * Devolve TRUE se a fila "f" estiver vazia,
 * e devolve FALSE caso contrrio.
 */
BOOLEAN estaVazia(Fila* f);

/*
 * Devolve TRUE se a fila "f" estiver cheia,
 * e devolve FALSE caso contrrio.
 */
BOOLEAN estaCheia(Fila* f);

/*
 * Insere o "elemento" no fim da fila "f".
 */
void insere(Fila* f, TIPO elemento);

/*
 * Remove e devolve o elemento que est no incio da fila "f".
 */
TIPO retira (Fila* f);

/*
 * Devolve um ponteiro para uma fila (inicialmente vazia) com
 * capacidade para "qtdMaxElem" elementos.
 */
Fila* novaFila(int capacidade);



