#include "fila.h"
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

BOOLEAN estaVazia(Fila* f) {
   return f->ini == f->fim;
}

BOOLEAN estaCheia(Fila* f) {
   return (f->fim + 1) % (f->capacidade + 1) == f->ini;
}

void insere(Fila* f, TIPO elemento) {
   assert(!estaCheia(f));
   f->fila[f->fim] = elemento;
   f->fim = (f->fim + 1) % (f->capacidade + 1);
}

TIPO retira (Fila* f) {
   TIPO elemento;
   assert(!estaVazia(f));
   elemento = f->fila[f->ini];
   f->ini = (f->ini + 1) % (f->capacidade + 1);
   return elemento;
}

Fila* novaFila(int capacidade) {
   Fila* f = malloc(sizeof(Fila));
   f->capacidade = capacidade;
   f->fila = malloc(sizeof(TIPO) * (f->capacidade + 1));
   f->ini = f->fim = 0;
   return f;
}

