/*
 * quantidade mxima de elementos que podem
 * estar contidos em uma pilha
 */
#define TAM_MAX_PILHA 100

/*
 * tipo de dado que ser armazenado na pilha
 */
#define TIPO char

/* constantes para trabalhar com tipo "booleano" */
#define BOOLEAN int
#define TRUE 1
#define FALSE 0

/*
 * Estrutura que representa uma pilha (utiliza o
 * paradigma LIFO "last in first out").
 */
typedef struct Pilha {
   int topo;
   TIPO pilha[TAM_MAX_PILHA];
} Pilha;

/*
 * Devolve TRUE se a pilha "p" estiver vazia,
 * e devolve FALSE caso contrrio.
 */
BOOLEAN estaVazia(Pilha* p);

/*
 * Devolve TRUE se a pilha "p" estiver cheia,
 * e devolve FALSE caso contrrio.
 */
BOOLEAN estaCheia(Pilha* p);

/*
 * Insere o "elemento" no topo da pilha "p".
 */
void empilha(Pilha* p, TIPO elemento);

/*
 * Remove e devolve o elemento que est no topo da pilha "p".
 */
TIPO desempilha (Pilha* p);

/*
 * Devolve o elemento que est no topo da pilha "p".
 */
TIPO topo (Pilha* p);

/*
 * Inicializa a pilha "p" (inicialmente a pilha "p" est vazia).
 */
void inicializa(Pilha* p);



