/*
 * Adaptao do cdigo apresentado em
 * www.ime.usp.br/~pf/algoritmos/aulas/pilha.html
 * do prof Paulo Feofiloff
 */

#include <stdio.h>
#include "pilha.h"
#include <assert.h>
#include <stdlib.h>

#define TAM_MAX_EXP 100

int precedencia(char operador) {
   switch(operador) {
      case '(': return 0;
      case '-': return 1;
      case '+': return 2;
      default:  return 3; /* '*' ou '/' */
   }
}

void infixaParaPosfixa(char inf[], char posf[]) {
   Pilha p;
   int i, j;
   char x;

   j = 0;
   inicializa(&p);

   for(i = 0; inf[i] != '\0'; i++) {
      switch(inf[i]) {
         case '(':   empilha(&p, inf[i]);
                   break;

         case ')':   x =  desempilha(&p);
                  while(x != '(') {
                     posf[j++] = x;
                       x =  desempilha(&p);
                  }
                  break;

         case '+':
         case '-':
         case '*':
         case '/':   x = topo(&p);
                  while(precedencia(x) >= precedencia(inf[i])) {
                     desempilha(&p);
                     posf[j++] = x;
                     x = topo(&p);
                  }
                  empilha(&p, inf[i]);
                  break;

         default:  posf[j++] = inf[i];
      }
   }

   assert(estaVazia(&p));
   posf[j] = '\0';
}

int main() {
   int n, i, j;
   char c;
   char posf[TAM_MAX_EXP];
   char inf[TAM_MAX_EXP];
   scanf("%d\n", &n);

   for(i = 0; i < n; i++) {
      j = 0;

      while(TRUE) {
         scanf("%c", &c);

         if(c == '\n') {
            break;
         }

         inf[j++] = c;
      }

      inf[j] = '\0';
      infixaParaPosfixa(inf, posf);
      printf("%s\n", posf);
   }

   return 0;
}
