#include "pilha.h"
#include <stdio.h>
#include <assert.h>

#define QTD_MAX_CHARS 100
#define ESTOU_NO_LINUX

BOOLEAN ehFecha(char c) {
   return c == ')' || c == ']' || c == '}';
}

BOOLEAN fechaCorretamente(char c1, char c2) {
   if(c1 == '(' && c2 == ')') return TRUE;
   if(c1 == '[' && c2 == ']') return TRUE;
   if(c1 == '{' && c2 == '}') return TRUE;

   return FALSE;
}

BOOLEAN bemFormada (char s[]) {
   Pilha p;
   int i;
   char simb;
   inicializa(&p);

   for (i = 0; s[i] != '\0'; i++) {
      if(ehFecha(s[i])) {
         if(estaVazia(&p)) {
            return FALSE;
         }

         simb = desempilha(&p);

         if(!fechaCorretamente(simb, s[i])) {
            return FALSE;
         }
      } else {   
         empilha(&p, s[i]);
      }
   }

   if (estaVazia(&p)) {
      return TRUE;
   } else {
      return FALSE;
   }
}

void leLinha(char str[]) {
   char c;
   int i = 0;

   while(TRUE) {
      scanf("%c", &c);

      #ifdef ESTOU_NO_WINDOWS
      if(c == '\n') {
         break;
      }
      #endif

      #ifdef ESTOU_NO_LINUX
      if(c == '\r') {
	 scanf("%c", &c);
         break;
      }
      #endif

      str[i++] = c;
      assert(i < QTD_MAX_CHARS + 1);
   }

   str[i] = '\0';
}

int main() {
   int i, n;
   char exp[QTD_MAX_CHARS + 1];
   scanf("%d\n", &n);

   for(i = 0; i < n; i++) {
      leLinha(exp);

      if(bemFormada(exp)) {
         printf("\na expressao \"%s\" esta bem formada.\n", exp);
      } else {
         printf("\na expressao \"%s\" nao esta bem formada.\n", exp);
      }
   }

   return 0;
}

