#include "pilha.h"
#include <assert.h>

TIPO topo (Pilha* p) {
   assert(!estaVazia(p));
   return p->pilha[p->topo];
}

int estaVazia(Pilha* p) {
   return p->topo == -1;
}

int estaCheia(Pilha* p) {
   return p->topo == TAM_MAX_PILHA - 1;
}

void empilha(Pilha* p, TIPO elemento) {
   assert(!estaCheia(p));
   p->pilha[++p->topo] = elemento;
}

TIPO desempilha (Pilha* p) {
   assert(!estaVazia(p));
   return p->pilha[p->topo--];
}

void inicializa(Pilha* p) {
   p->topo = -1;
}


