package br.usp.ime.mac438;

import static org.junit.Assert.*;

import org.junit.Test;

public class TesteDoMain {
	@Test
	public void obtemNumeroDeArrayDevolveNumeroSeEstiverNoArray()
			throws Exception {
		String[] argumentos = new String[] {"1"};
		int numero = Main.obtemNumeroOuDevolvePadrao(argumentos, 0, 10);
		assertEquals(1, numero);
	}
	
	@Test
	public void obtemNumeroDeArrayDependendoDoIndice() throws Exception {
		String[] argumentos = new String[] {"1", "3"};
		int numero = Main.obtemNumeroOuDevolvePadrao(argumentos, 1, 10);
		assertEquals(3, numero);
	}
	
	@Test
	public void devolveValorPadraoSeIndiceNaoForNumero() throws Exception {
		String[] argumentos = new String[] {"1", "oi"};
		int numero = Main.obtemNumeroOuDevolvePadrao(argumentos, 1, 10);
		assertEquals(10, numero);
	}
	
	@Test
	public void devolveValorPadraoSeNumeroForNaoPositivo() throws Exception {
		String[] argumentos = new String[] {"0", "-3"};
		int numero = Main.obtemNumeroOuDevolvePadrao(argumentos, 0, 10);
		assertEquals(10, numero);
		numero = Main.obtemNumeroOuDevolvePadrao(argumentos, 1, 10);
		assertEquals(10, numero);
	}
	
	@Test
	public void inicializaAtributosCom20E80E1000() throws Exception {
		String[] argumentos = new String[] {};
		Main.inicializaAtributos(argumentos);
		assertEquals(20, Main.numeroDeAtendentes());
		assertEquals(80, Main.numeroDeClientes());
		assertEquals(1000, Main.limiteDeChamadas());
	}
	
	@Test
	public void inicializaAtributosComValoresPassados() throws Exception {
		String[] argumentos = new String[] {"5", "10", "100"};
		Main.inicializaAtributos(argumentos);
		assertEquals(5, Main.numeroDeAtendentes());
		assertEquals(10, Main.numeroDeClientes());
		assertEquals(100, Main.limiteDeChamadas());
	}
}
