package br.usp.ime.mac438;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

public class TesteDoCliente {

	private Cliente cliente;
	private Central central;
	private int atendentes;

	@Before
	public void criaCliente() {
		atendentes = 0;
		criaClienteComCentralDeTamanho(1);
	}

	private void criaClienteComCentralDeTamanho(int tamanho) {
		central = new Central(tamanho);
		cliente = new Cliente(0, central, new StubRandom(0));
	}
	
	@Test
	public void clienteNovoNaoFezNenhumaLigacao() throws Exception {
		assertEquals(0, cliente.ligacoesRealizadas());
	}
	
	@Test
	public void clienteAposLigarUmaVezFezUmaLigacao() throws Exception {
		cliente.liga();
		assertEquals(1, cliente.ligacoesRealizadas());
	}
	
	@Test
	public void clienteAposLigarVariasVezesFezVariasLigacoes() throws Exception {
		criaClienteComCentralDeTamanho(5);
		cliente.liga();
		cliente.liga();
		cliente.liga();
		assertEquals(3, cliente.ligacoesRealizadas());
	}
	
	@Test
	public void clienteEhRunnable() throws Exception {
		assertTrue(cliente instanceof Runnable);
	}
	
	@Test
	public void clienteLigaPraCentralDeUmaLigacaoApenasUmaVez() throws Exception {
		Thread atendente = new Thread(criaAtendentes());
		atendente.start();
		cliente.run();
		assertFalse(central.recebeLigacoes());
		assertEquals(1, cliente.ligacoesRealizadas());
	}

	private Atendente criaAtendentes() {
		return new Atendente(atendentes++, central, new StubRandom(0));
	}
	
	@Test
	public void clienteLigaPraCentralDeTresLigacoesTresVezes() throws Exception {
		criaClienteComCentralDeTamanho(3);
		Thread atendente = new Thread(criaAtendentes());
		atendente.start();
		cliente.run();
		assertFalse(central.recebeLigacoes());
		assertEquals(3, cliente.ligacoesRealizadas());
	}
	
	@Test
	public void relatorioDeClienteNovoMarca0Ligacoes() throws Exception {
		assertEquals("Cliente 0: 0 ligaes realizadas", cliente.relatorio());
	}
	
	@Test
	public void relatorioDeClienteComLigacoesImprimeONumero() throws Exception {
		criaClienteComCentralDeTamanho(2);
		cliente.liga();
		cliente.liga();
		assertEquals("Cliente 0: 2 ligaes realizadas", cliente.relatorio());
	}
	
	@Test
	public void relatorioDeClientesDiferentesImprimeIdenficadorDoCliente() throws Exception {
		Cliente outro = new Cliente(2, central);
		assertEquals("Cliente 2: 0 ligaes realizadas", outro.relatorio());
	}

	@Test
	public void clienteUsaORandomPassadoAoFazerOutraCoisa() throws Exception {
		StubRandom random = new StubRandom(0);
		Cliente comRandomSetado = new Cliente(0, central, random);
		comRandomSetado.fazOutraCoisa();
		assertEquals(1, random.chamadas());
	}
}
