package br.usp.ime.mac438;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

public class TesteDoAtendente {
	private Atendente atendente;
	private Central central;
	private int clientes;
	private int atendentes;

	@Before
	public void criaAtendente() {
		clientes = 0;
		criaAtendenteComCentralDeTamanho(1);
	}

	private void criaAtendenteComCentralDeTamanho(int tamanho) {
		central = new Central(tamanho);
		atendentes = 0;
		atendente = new Atendente(atendentes++, central, new StubRandom(0));
	}

	@Test
	public void atendenteNovoNaoRecebeuNenhumaLigacao() throws Exception {
		assertEquals(0, atendente.ligacoesRecebidas());
	}

	@Test
	public void atendenteAposReceberUmClienteRecebeuUmaLigacao()
			throws Exception {
		central.recebeCliente(novoCliente());
		atendente.recebeCliente();
		assertEquals(1, atendente.ligacoesRecebidas());
	}

	private Cliente novoCliente() {
		return new Cliente(clientes++, central);
	}

	@Test
	public void atendenteAposReceberVariosClientesRecebeuVariasLigacoes()
			throws Exception {
		criaAtendenteComCentralDeTamanho(5);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		atendente.recebeCliente();
		atendente.recebeCliente();
		atendente.recebeCliente();
		atendente.recebeCliente();
		assertEquals(4, atendente.ligacoesRecebidas());
	}

	@Test
	public void atendenteEhRunnable() throws Exception {
		assertTrue(atendente instanceof Runnable);
	}

	@Test
	public void atendenteAtendeClientesEnquantoNaoEncerrouExpediente()
			throws Exception {
		central.recebeCliente(novoCliente());
		atendente.run();
		assertTrue(central.encerrouExpediente());
	}

	@Test
	public void atendenteAtendeTresClientesSeCentralRecebeTresLigacoes()
			throws Exception {
		criaAtendenteComCentralDeTamanho(3);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		atendente.run();
		assertTrue(central.encerrouExpediente());
		assertEquals(3, atendente.ligacoesRecebidas());
	}

	@Test
	public void relatorioDeNovoAtendenteNaoTemLigacoesRecebidas()
			throws Exception {
		assertEquals("Atendente 0: 0 ligaes recebidas", atendente.relatorio());
	}

	@Test
	public void relatorioDeAtendenteComLigacoesMostraONumero() throws Exception {
		criaAtendenteComCentralDeTamanho(5);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		atendente.recebeCliente();
		atendente.recebeCliente();
		atendente.recebeCliente();
		atendente.recebeCliente();
		assertEquals("Atendente 0: 4 ligaes recebidas", atendente.relatorio());
	}

	@Test
	public void relatorioDeOutroAtendenteTemSeuIdentificador() throws Exception {
		Atendente outroAtendente = new Atendente(5, central);
		assertEquals("Atendente 5: 0 ligaes recebidas", outroAtendente
				.relatorio());
	}

	@Test
	public void atendenteAoAnotarReclamacaoUsaORandomPassado() throws Exception {
		StubRandom random = new StubRandom(0);
		Atendente comRandomSetado = new Atendente(0, central, random);
		comRandomSetado.anotarReclamacao(new Atendimento(novoCliente()));
		assertEquals(1, random.chamadas());
	}
}
