package br.usp.ime.mac438;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;

public class TesteDaCentral {
	private Central central;
	private int clientes;

	@Before
	public void criaCentral() {
		central = new Central(1);
		clientes = 0;
	}

	@Test
	public void centralNovaNaoTratouNenhumaChamada() throws Exception {
		assertEquals(0, central.chamadasTratadas());
	}

	@Test
	public void centralAposReceberUmClienteTratouUmaChamada() throws Exception {
		central.recebeCliente(novoCliente());
		assertEquals(1, central.chamadasTratadas());
	}

	private Cliente novoCliente() {
		return new Cliente(clientes++, central);
	}

	@Test
	public void centralAposReceberVariosClientesTratouVariasChamadas()
			throws Exception {
		central = new Central(10);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		assertEquals(5, central.chamadasTratadas());
	}

	@Test
	public void centralCriaAtendimentoAoReceberCliente() throws Exception {
		Cliente cliente = novoCliente();
		Atendimento atendimento = central.recebeCliente(cliente);
		assertNotNull(atendimento);
		assertEquals(cliente, atendimento.cliente());
	}

	@Test
	public void centralPorPadraoRecebeUmaLigacaoNoMaximo() throws Exception {
		assertTrue(central.recebeLigacoes());
		central.recebeCliente(novoCliente());
		assertFalse(central.recebeLigacoes());
	}

	@Test
	public void centralRecebeLigacoesAteAtingirLimite() throws Exception {
		central = new Central(5);
		central.recebeCliente(novoCliente());
		assertTrue(central.recebeLigacoes());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		assertTrue(central.recebeLigacoes());
		central.recebeCliente(novoCliente());
		assertFalse(central.recebeLigacoes());
	}

	@Test
	public void centralNaoEncerrouExpedienteEnquandoNaoAtingirLimite()
			throws Exception {
		assertFalse(central.encerrouExpediente());
	}

	@Test
	public void centralDevolveAtendimentoCorrespondeAoCliente()
			throws Exception {
		Cliente cliente = novoCliente();
		central.recebeCliente(cliente);

		Atendimento atendimento = central.atenderCliente();
		assertNotNull(atendimento);
		assertEquals(cliente, atendimento.cliente());
	}

	@Test
	public void centralDevolveClienteNaOrdemDeChegada() throws Exception {
		central = new Central(5);
		Cliente cliente1 = novoCliente();
		Cliente cliente2 = novoCliente();
		central.recebeCliente(cliente1);
		central.recebeCliente(cliente2);

		Atendimento atendimento = central.atenderCliente();
		assertEquals(cliente1, atendimento.cliente());
		atendimento = central.atenderCliente();
		assertEquals(cliente2, atendimento.cliente());
	}

	@Test
	public void encerraExpedienteSoDepoisDeAtenderTodosOsClientes()
			throws Exception {
		central = new Central(3);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		assertFalse(central.recebeLigacoes());
		assertFalse(central.encerrouExpediente());
		central.atenderCliente();
		central.atenderCliente();
		central.atenderCliente();
		assertFalse(central.recebeLigacoes());
		assertTrue(central.encerrouExpediente());
	}

	@Test(expected = IllegalStateException.class)
	public void centralRejeiteLigacoesAposAtingirLimite() throws Exception {
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
	}
	
	@Test
	public void relatorioDeCentralNovaMarca0Ligacoes() throws Exception {
		assertEquals("Ligaes recebidas: 0", central.relatorio());
	}
	
	@Test
	public void relatorioDeCentralComLigacoesImprimeONumero() throws Exception {
		central = new Central(2);
		central.recebeCliente(novoCliente());
		central.recebeCliente(novoCliente());
		assertEquals("Ligaes recebidas: 2", central.relatorio());
	}
}
