package br.usp.ime.mac438;

import java.util.LinkedList;
import java.util.List;

public class Main {
	private static int limiteDeChamadas;
	private static int numeroDeAtendentes;
	private static int numeroDeClientes;

	public static int limiteDeChamadas() {
		return limiteDeChamadas;
	}

	public static int numeroDeAtendentes() {
		return numeroDeAtendentes;
	}

	public static int numeroDeClientes() {
		return numeroDeClientes;
	}

	public static void main(String[] argumentos) {
		inicializaAtributos(argumentos);

		Central central = new Central(limiteDeChamadas);
		List<Atendente> atendentes = criaAtendentes(central);
		List<Cliente> clientes = criaClientes(central);

		List<Thread> threads = iniciaThreads(atendentes, clientes);

		esperaAcabar(central, threads);

		imprimeRelatorios(central, atendentes, clientes);
	}

	static void inicializaAtributos(String[] argumentos) {
		numeroDeAtendentes = obtemNumeroOuDevolvePadrao(argumentos, 0, 20);
		numeroDeClientes = obtemNumeroOuDevolvePadrao(argumentos, 1, 80);
		limiteDeChamadas = obtemNumeroOuDevolvePadrao(argumentos, 2, 1000);
	}

	static int obtemNumeroOuDevolvePadrao(String[] argumentos,
			int indice, int valorPadrao) {
		if (argumentos.length > indice) {
			try {
				int valor = Integer.parseInt(argumentos[indice]);
				if (valor > 0)
					return valor;
			} catch (NumberFormatException e) {
			}
		}
	
		return valorPadrao;
	}

	private static List<Atendente> criaAtendentes(Central central) {
		List<Atendente> criaAtendentes = new LinkedList<Atendente>();
		for (int i = 0; i < numeroDeAtendentes; i++)
			criaAtendentes.add(new Atendente(i, central));
		return criaAtendentes;
	}

	private static List<Cliente> criaClientes(Central central) {
		List<Cliente> criaClientes = new LinkedList<Cliente>();
		for (int i = 0; i < numeroDeClientes; i++)
			criaClientes.add(new Cliente(i, central));
		return criaClientes;
	}

	private static List<Thread> iniciaThreads(List<Atendente> atendentes,
			List<Cliente> clientes) {
		List<Thread> threads = mapeiaParaThread(atendentes, clientes);
		for (Thread thread : threads) {
			thread.start();
		}
		return threads;
	}

	private static List<Thread> mapeiaParaThread(
			List<Atendente> criaAtendentes, List<Cliente> criaClientes) {
		List<Thread> threads = new LinkedList<Thread>();
		for (Atendente atendente : criaAtendentes) {
			threads.add(new Thread(atendente));
		}
	
		for (Cliente cliente : criaClientes) {
			threads.add(new Thread(cliente));
		}
		return threads;
	}

	private static void esperaAcabar(Central central, List<Thread> threads) {
		while (!central.encerrouExpediente()) {
			for (Thread thread : threads) {
				try {
					thread.join();
				} catch (InterruptedException e) {
				}
			}
		}
	}

	private static void imprimeRelatorios(Central central,
			List<Atendente> atendentes, List<Cliente> clientes) {
		System.out.println(central.relatorio());
		for (Atendente atendente : atendentes) {
			System.out.println(atendente.relatorio());
		}
		for (Cliente cliente : clientes) {
			System.out.println(cliente.relatorio());
		}
	}
}
