package br.usp.ime.mac438;

import java.util.Random;

public class Cliente implements Runnable {

	private static final int TEMPO_MAXIMO_FAZENDO_OUTRA_COISA = 1000;
	private Central central;
	private int ligacoesRealizadas;
	private int identificador;
	private Random random;

	public Cliente(int identificador, Central central) {
		this(identificador, central, new Random());
	}

	public Cliente(int identificador, Central central, Random random) {
		this.identificador = identificador;
		this.central = central;
		this.random = random;
		this.ligacoesRealizadas = 0;
	}

	public int ligacoesRealizadas() {
		return ligacoesRealizadas;
	}

	public Atendimento liga() {
		Atendimento atendimento = central.recebeCliente(this);
		ligacoesRealizadas++;
		return atendimento;
	}

	public void run() {
		while (central.recebeLigacoes()) {
			Atendimento atendimento = liga();
			esperaSerAtendido(atendimento);
			fazReclamacao(atendimento);
			fazOutraCoisa();
		}
	}

	private void esperaSerAtendido(Atendimento atendimento) {
		atendimento.esperaSerAtendido();
	}

	private void fazReclamacao(Atendimento atendimento) {
		atendimento.esperaAnotarReclamacao();
	}

	void fazOutraCoisa() {
		try {
			long tempoFazendoOutraCoisa = Math.abs(random.nextLong())
					% TEMPO_MAXIMO_FAZENDO_OUTRA_COISA;
			Thread.sleep(tempoFazendoOutraCoisa);
		} catch (InterruptedException e) {
			// Cansei! Vou ligar de novo
		}
	}

	public String relatorio() {
		return "Cliente " + identificador + ": " + ligacoesRealizadas
				+ " ligaes realizadas";
	}
}
