package br.usp.ime.mac438;

import java.util.concurrent.ConcurrentLinkedQueue;

public class Central {

	private int chamadasTratadas;
	private int limiteDeChamadas;
	private ConcurrentLinkedQueue<Atendimento> filaDeClientes;

	public Central(int limiteDeChamadas) {
		this.limiteDeChamadas = limiteDeChamadas;
		this.filaDeClientes = new ConcurrentLinkedQueue<Atendimento>();
	}

	/**
	 * Deve ser synchronized para garantir que a soma no ser interrompida no meio.
	 * @return O nmero de chamadas tratadas
	 */
	public synchronized int chamadasTratadas() {
		return chamadasTratadas;
	}

	public Atendimento recebeCliente(Cliente cliente) {
		recebeLigacaoSePuder();
		Atendimento atendimento = new Atendimento(cliente);
		filaDeClientes.add(atendimento);
		acordaAtendentes();
		return atendimento;
	}

	/**
	 * DEVE ser synchronized pois preciso verificar o valor e adicionar atomicamente.
	 */
	private synchronized void recebeLigacaoSePuder() {
		if (!recebeLigacoes())
			throw new IllegalStateException(
					"J encerrei o recebimento de ligacoes");
		chamadasTratadas++;
	}

	public boolean recebeLigacoes() {
		return chamadasTratadas() < limiteDeChamadas;
	}

	public boolean encerrouExpediente() {
		return !recebeLigacoes() && filaDeClientes.isEmpty();
	}

	public Atendimento atenderCliente() {
		Atendimento atendimento = null;
		while (!encerrouExpediente() && !atendenteAchouCliente(atendimento)) {
			if (filaDeClientes.isEmpty()) {
				liberaAtendenteProCafezinho();
			}
			atendimento = filaDeClientes.poll();
		}
		return atendimento;
	}

	private boolean atendenteAchouCliente(Atendimento atendimento) {
		return atendimento != null;
	}

	/**
	 * Deve ser synchronized para eu poder dar o notifyAll.
	 */
	private synchronized void acordaAtendentes() {
		notifyAll();
	}

	/**
	 * Deve ser synchronized para eu poder dar o wait.
	 */
	private synchronized void liberaAtendenteProCafezinho() {
		try {
			wait();
		} catch (InterruptedException e) {
			// Opa! Cliente?
		}
	}

	public String relatorio() {
		return "Ligaes recebidas: " + chamadasTratadas;
	}
}
