package br.usp.ime.mac438;

public class Atendimento {

	public enum Status {
		ESPERANDO, SENDO_ATENDIDO, ATENDIDO;
	}

	private Cliente cliente;
	private Status status;

	public Atendimento(Cliente cliente) {
		this.cliente = cliente;
		this.status = Status.ESPERANDO;
	}

	public Cliente cliente() {
		return cliente;
	}

	public void esperaSerAtendido() {
		while (status == Status.ATENDIDO) {
			enrolarCliente();
		}
	}

	public void esperaAnotarReclamacao() {
		while (status != Status.ATENDIDO) {
			enrolarCliente();
		}
	}

	public void foiPego() {
		status = Status.SENDO_ATENDIDO;
		acordarCliente();
	}

	public void acabou() {
		status = Status.ATENDIDO;
		acordarCliente();
	}

	private synchronized void acordarCliente() {
		notify();
	}

	private synchronized void enrolarCliente() {
		try {
			wait();
		} catch (InterruptedException e) {
		}
	}

}
