package br.usp.ime.mac438;

import java.util.Random;

public class Atendente implements Runnable {

	private static final int TEMPO_MAXIMO_DE_ESPERA = 1000;
	private int ligacoesRecebidas;
	private int identificador;
	private Central central;
	private Random random;

	public Atendente(int identificador, Central central) {
		this(identificador, central, new Random());
	}

	public Atendente(int identificador, Central central, Random random) {
		this.identificador = identificador;
		this.central = central;
		this.random = random;
		this.ligacoesRecebidas = 0;
	}

	public int ligacoesRecebidas() {
		return ligacoesRecebidas;
	}

	public Atendimento recebeCliente() {
		Atendimento atendimento = central.atenderCliente();
		ligacoesRecebidas++;
		return atendimento;
	}

	public void run() {
		while (!central.encerrouExpediente()) {
			Atendimento atendimento = recebeCliente();
			if (conseguiUmCliente(atendimento)) {
				atendimento.foiPego();
				anotarReclamacao(atendimento);
			}
		}
	}

	private boolean conseguiUmCliente(Atendimento atendimento) {
		return atendimento != null;
	}

	void anotarReclamacao(Atendimento atendimento) {
		try {
			long tempoAnotando = Math.abs(random.nextLong()) % TEMPO_MAXIMO_DE_ESPERA;
			Thread.sleep(tempoAnotando);
		} catch (InterruptedException e) {
			// Ah! Cliente desligou na minha cara
			// Prximo!
		}
		atendimento.acabou();
	}

	public String relatorio() {
		return "Atendente " + identificador + ": " + ligacoesRecebidas
				+ " ligaes recebidas";
	}
}
