
#include "notes.h"

;  Cria as tabelas com a forma de onda principal (f1), a envoltria
;  dinmica (f2) e os grficos de freqncias secundrias para 
;  a sntese FM (tabelas f3, f4 e f5).

; gera um perodo de uma onda senoidal
f 1 0 4096 10 1
; envoltria dinmica
f 2 0 1024 5 0.001 14 1 1010 0.001
; sinal ascendente (4 oitavas)
f 3 0 1024 -5 0.25 1024 4
; sinal constante
f 4 0 1024 7 1 1024 1
; sinal decrescente (4 oitavas)
f 5 0 1024 -5 4 1024 0.25

;  O macro FM permite criar uma melodia especificando a durao
;  de cada nota, a freqncia principal, a freqncia secundria (referncia),
;  a amplitude secundria (referncia) e as tabelas de variao da freqncia
;  secundria e da amplitude secundria.

#define FMVAR(DUR#FA#FB#AB#TA#TB) #i 999 + [$DUR.] 15000 [$FA.] $TA. $TB. $AB. [$FB.]#

; H=5.99...0.37, I=0.09...24.27
$FMVAR(8#$A.5#$E.6#5000#5#3)
; H=0.28...4.49, I=3.88...0.015
$FMVAR(8#$D.1#$E.1#10#3#5)
; H=1, I=0.14...2.27
$FMVAR(8#$A.4#$A.4#250#4#3)
; H=1.5, I=0.38...6.07
$FMVAR(8#$A.4#$E.5#1000#4#3)
; H=1, I=0.011
$FMVAR(8#$A.4#$A.4#5#4#4)
; H=2.38...0.15, I=0.001...0.015
$FMVAR(8#$A.4#$C.4#1#5#4)
; H=2.24, I=0.004...0.0002
$FMVAR(8#$A.4#$B.5#1#4#5)
; H=0.02...0.33, I=0.11...0.007
$FMVAR(8#$A.4#$D.1#1#3#4)
; H=0.066, I=0.007...0.11
$FMVAR(8#$Cs.4#$D.1#1#4#3)
; H=0.22...3.56, I=0.36...0.001
$FMVAR(8#$G.1#$F.1#1#3#5)
; H=0.75...0.07, I=0.0001...0.036
$FMVAR(8#$D.7#$A.4#1#5#3)
; H=0.5, I=0.103
$FMVAR(8#$Eb.1#$Eb.0#2#4#4)

