; O instrumento a seguir ilustra alguns usos da tcnica
; de "Predio Linear". O arquivo de entrada  analisado com
; csound -U lpanal teste.wav teste.lp

          instr     999
idur      =         p3

icase     =         p4
; o caso 0 toca o arquivo original
if (icase==0) goto play

; o caso 2 toca um som de corda por KS
if (icase==2) goto string

; o caso 4 toca um som de sino usando FM
if (icase==4) goto bell

; o caso 1 resintetiza o arquivo original usando lp
; o caso 3 resintetiza o som de corda usando lp
; o caso 5 resintetiza o som de sino usando lp
; nos 3 casos, so usados os dados de anlise 

goto lpresynth

play:

aout      soundin   "teste.wav"
          goto end


string:

iampst    =         ampdbfs(p7)
ifrqst    =         cpspch(p8)
kenv      oscil     1, 1/idur, 2
asig      pluck     iampst*kenv, ifrqst, ifrqst, 0, 1
if (icase==3) goto lpres
aout      =         asig
goto end


bell:

iampst    =         ampdbfs(p7)
ifrqst    =         cpspch(p8)
kenv      oscil     1, 1/idur, 2
asig      foscil    iampst*kenv, ifrqst, 1, 1.4, 8*kenv, 1
if (icase==5) goto lpres
aout      =         asig
goto end


lpresynth:

ibeg      =         p5
iend      =         p6
ktimp     line      ibeg, idur, iend
krmsr, krmso, kerr, kcps    lpread  ktimp, "teste.lp"

if (icase==3) goto string
if (icase==5) goto bell

asig1     buzz      krmso, kcps, int(22050/kcps), 1
asig2     rand      krmso
if        (kerr > .001) goto userand
asig      =         asig1
goto      lpres
userand:
asig      =         asig2
goto      lpres

lpres:
aout      lpreson   asig*ampdb(-18)

end:
          out       aout
          endin

