#include "m_pd.h"
#include "math.h"
#ifdef NT
#pragma warning( disable : 4244 )
#pragma warning( disable : 4305 )
#endif

/* ------------------------ filtro2P~ ----------------------------- */

/* tilde object to take absolute value. */

static t_class *filtro2P_class;

typedef struct _filtro2P
{
  t_object x_obj; /* obligatory header */
  t_float x_f;    /* sample value */
  t_float phi;    /* fase do polo principal */
  t_float mag;    /* magnitude do polo principal */
  t_float yn1;    /* saida anterior do filtro */
  t_float yn2;    /* saida anterior do filtro */
} t_filtro2P;

void filtro2P_ft1(t_filtro2P *x, t_floatarg f) {
  /* transforma a frequencia f (em Hz) do segundo inlet
     na frequencia angular phi = 2*pi*f/SR, onde SR=44100Hz */
  x->phi = 0.00014248*f;
}

void filtro2P_ft2(t_filtro2P *x, t_floatarg f) {
  /* armazena a magnitude do polo (entrada pelo terceiro inlet) */
  x->mag = f;
}



/* this is the actual performance routine which acts on the samples.
   It's called with a single pointer "w" which is our location in the
   DSP call list.  We return a new "w" which will point to the next item
   after us.  Meanwhile, w[0] is just a pointer to dsp-perform itself
   (no use to us), w[1] and w[2] are the input and output vector locations,
   and w[3] is the number of points to calculate. */
static t_int *filtro2P_perform(t_int *w)
{
  t_float *in = (t_float *)(w[1]);
  t_float *out = (t_float *)(w[2]);
  int n = (int)(w[3]);
  t_filtro2P *x = (t_filtro2P *)(w[4]);
  
  /* valores anteriores de saida do filtro */
  t_float yn1=x->yn1, yn2=x->yn2;

  while (n--)
    {
      float f = *(in++);
      
      /* a formula para o filtro com dois polos conjugados
	 em R*e^(i*phi) e R*e^(-i*phi) e'
	 
	 y(n) = x(n)+2Rcos(phi)y(n-1) +R^2y(n-2)
	 
	 cuja resposta em frequencia foi renormalizada atraves
	 do fator (1-R)Rsin(phi), que multiplicado por x(n)
	 deixa o pico de amplificacao em 1. Na formula abaixo,
	 R=x->mag, phi=x->phi, x(n)=f, yn1=y(n-1) e yn2=y(n-2) */
      
      *out = (1.0-x->mag)*2*x->mag*sin(x->phi)*f+2*x->mag*cos(x->phi)*yn1-x->mag*x->mag*yn2;
      x->yn2 = yn2 = yn1;
      x->yn1 = yn1 = *out;
      out++;
    }
  return (w+5);
}

/* called to start DSP.  Here we call Pd back to add our perform
   routine to a linear callback list which Pd in turn calls to grind
   out the samples. */
static void filtro2P_dsp(t_filtro2P *x, t_signal **sp)
{
  dsp_add(filtro2P_perform, 4, sp[0]->s_vec, sp[1]->s_vec, sp[0]->s_n, x);
}

static void *filtro2P_new(void)
{
    t_filtro2P *x = (t_filtro2P *)pd_new(filtro2P_class);
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, gensym("float"), gensym("ft1"));
    inlet_new(&x->x_obj, &x->x_obj.ob_pd, gensym("float"), gensym("ft2"));
    outlet_new(&x->x_obj, gensym("signal"));
    x->x_f = x->phi = x->mag = x->yn1 = x->yn2 = 0;
    return (x);
}

/* this routine, which must have exactly this name (with the "~" replaced
   by "_tilde) is called when the code is first loaded, and tells Pd how
   to build the "class". */
void filtro2P_tilde_setup(void)
{
  filtro2P_class = class_new(gensym("filtro2P~"),
			     (t_newmethod)filtro2P_new, 0,
			     sizeof(t_filtro2P), 0, A_DEFFLOAT, 0);
  /* this is magic to declare that the leftmost, "main" inlet
     takes signals; other signal inlets are done differently... */
  CLASS_MAINSIGNALIN(filtro2P_class, t_filtro2P, x_f);
  /* here we tell Pd about the "dsp" method, which is called back
     when DSP is turned on. */
  class_addmethod(filtro2P_class, (t_method)filtro2P_dsp, gensym("dsp"), 0);
  class_addmethod(filtro2P_class, (t_method)filtro2P_ft1, gensym("ft1"), A_FLOAT, 0);
  class_addmethod(filtro2P_class, (t_method)filtro2P_ft2, gensym("ft2"), A_FLOAT, 0);
}
