
printf("\nEXEMPLO DE FILTRO COM 1 ZERO: f=220Hz, quadrada\n");
printf("ZERO variando linearmente entre -1 (R/2 Hz) e 1 (0 Hz)\n");
fflush(stdout);

# Frequencia
f=220;

# Duracao
d=5;

# Taxa de Amostragem
R=8000;

# Cria onda quadrada, toca e mostra na tela.
x=squaretone(f,R,d,1);
plotnplay(x,R);

# r percorre linearmente os valores entre -1 e +1 (zero do filtro)
r=(-1:2/(d*R):1)';

# Aplica a equao do filtro
y=x;
for i=2:d*R
  y(i)=x(i)-r(i)*x(i-1);
end;

# Mostra as respostas de magnitude variando com a posio do zero do filtro
w=0:0.01:3.14;
for i=1:(R/10):d*R
  plotlim(w,abs(1-r(i)*exp(-sqrt(-1)*w)),0,2);
  pause(0.1);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);

printf("pressione qualquer tecla\n");pause;

printf("IDEM, com ruido branco\n");
fflush(stdout);

# Cria ruido branco e toca.
x=2*rand(d*R,1)-1;
plotnplay(x,R);

# Aplica a equao do filtro
y=x;
for i=2:d*R
  y(i)=x(i)-r(i)*x(i-1);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);






printf("\nEXEMPLO DE FILTRO COM 2 POLOS: f=220Hz, quadrada\n");
printf("POLOS da forma Ae^(i*phi) com phi variando entre 0 e pi\n");
fflush(stdout);

# Frequencia
f=220;

# Duracao
d=5;

# Taxa de Amostragem
R=8000;

# Cria onda quadrada, toca e mostra na tela.
x=squaretone(f,R,d,1);
plotnplay(x,R);

# Magnitude dos POLOS
A=0.8;

# Fase dos POLOS, percorre linearmente o intervalo [0,pi]
phi=(0:pi/(d*R):pi)';

# Aplica a equao do filtro
y=x;
y(2)=x(2)+2*A*cos(phi(2))*y(1);
for i=3:d*R
  y(i)=x(i)+2*A*cos(phi(i))*y(i-1)-A^2*y(i-2);
end;

# Mostra as respostas de magnitude variando com a posio dos polos do filtro
w=0:0.01:3.15;
for i=1:(R/10):d*R
  plotlim(w,abs(1./((1-A*exp(-sqrt(-1)*(w+phi(i)))).*(1-A*exp(-sqrt(-1)*(w-phi(i)))))),0,20);
  pause(0.1);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);

printf("pressione qualquer tecla\n");pause;

printf("IDEM, com ruido branco\n");
fflush(stdout);

# Cria ruido branco e toca.
x=2*rand(d*R,1)-1;
plotnplay(x,R);

# Aplica a equao do filtro
y=x;
y(2)=x(2)+2*A*cos(phi(2))*y(1);
for i=3:d*R
  y(i)=x(i)+2*A*cos(phi(i))*y(i-1)-A^2*y(i-2);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);












printf("\nEXEMPLO DE FILTRO COM 2 POLOS E 2 ZEROS: f=220Hz, quadrada\n");
printf("ZEROS em -1 e 1\n");
printf("POLOS da forma Ae^(i*phi) com phi variando entre 0 e pi\n");
printf("Filtro com banda estreita e resposta em frequencia normalizada\n");
fflush(stdout);

# Frequencia
f=220;

# Duracao
d=5;

# Taxa de Amostragem
R=8000;

# Cria onda quadrada, toca e mostra na tela.
x=squaretone(f,R,d,1);
plotnplay(x,R);

# Magnitude dos POLOS
A=0.99;

# Fase dos POLOS, percorre linearmente o intervalo [0,pi]
phi=(0:pi/(d*R):pi)';

# Aplica a equao do filtro
y=x;
y(2)=(1-A)*x(2)+2*A*cos(phi(2))*y(1);
for i=3:d*R
  y(i)=(1-A)*(x(i)-A*x(i-2))+2*A*cos(phi(i))*y(i-1)-A^2*y(i-2);
end;

# Mostra as respostas de magnitude variando com a posio dos polos do filtro
w=0:0.01:3.14;
for i=1:(R/10):d*R
  plotlim(w,abs((1-exp(-sqrt(-1)*w*2))./((1-A*exp(-sqrt(-1)*(w+phi(i)))).*(1-A*exp(-sqrt(-1)*(w-phi(i)))))),0,100);
  pause(0.1);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);

printf("pressione qualquer tecla\n");pause;

printf("IDEM, com ruido branco\n");
fflush(stdout);

# Cria ruido branco e toca.
x=2*rand(d*R,1)-1;
plotnplay(x,R);

# Aplica a equao do filtro
y=x;
y(2)=(1-A)*x(2)+2*A*cos(phi(2))*y(1);
for i=3:d*R
  y(i)=(1-A)*(x(i)-A*x(i-2))+2*A*cos(phi(i))*y(i-1)-A^2*y(i-2);
end;

# Normaliza o resultado e toca
y=y/max(y);
plotnplay(y,R);



