
# Faz o terminal do Octave imprimir as mensagens imediatamente
page_screen_output(false);

disp("Por favor leia os comentários no código.");

disp("Exemplo de construção do gráfico da função e^(i*w*t)");

# define uma escala de tempo de 0 a 10seg
# usando uma resolução de 1000 pontos
t = linspace(0,10,1000);

# frequencia angular correspondente ao período
# fundamental de 10seg (1 ciclo em 10 segundos)
w = 2*pi/10;

# define a função e^(i*w*t)
y = exp(i*w*t);

# plota em 3 dimensões os valores de t e
# os valores de y(t)=a(t)+i*b(t)
# onde a(t)=real(y(t)) e b(t)=imag(y(t))
plot3(t,real(y),imag(y));

disp("Pressione qualquer tecla...");pause;

disp("Plota os 10 harmônicos desta mesma função");

for m=1:10
  y = exp(i*m*w*t);
  plot3(t,real(y),imag(y));
  pause(0.5);
endfor

disp("Pressione qualquer tecla...");pause;




# outra forma de se visualizar a função y(t)=e^(i*w*t)
# é através de um gráfico 2D que mostra simultaneamente
# os sinais a(t) e b(t) em um mesmo gráfico, que
# correspondem a um cosseno e um seno respectivamente.

disp("Gráficos 2D das partes real e imaginária de e^(i*w*t)");

t = linspace(0,10,1000);
w = 2*pi/10;
y = exp(i*w*t);
plot(t,real(y),t,imag(y));

disp("Pressione qualquer tecla...");pause;

disp("Idem para os 10 harmônicos");

for m=1:10
  y = exp(i*m*w*t);
  plot(t,real(y),t,imag(y));
  pause(0.5);
endfor

disp("Pressione qualquer tecla...");pause;





# Exemplo de análise de um sinal quadrado com período
# 4 e oscilação entre 0 e 1, tendo o início do topo
# em t=-1

# tempo entre 0 e 10seg com maior resolução
t = linspace(0,10,10000);

# forma "compacta" de escrever a onda quadrada
x = mod(round(t/2),2)==0;

disp("Função quadrada a ser analisada");

# mostra o gráfico
plotlim(t,x,-2,2);

disp("Pressione qualquer tecla...");pause;

# Calcula os coeficientes da série de Fourier

# período
T = 4;

# frequência angular fundamental
w = 2*pi/T;

# conjunto de índices que correspondem a um período
# da forma de onda (de 0 a T seg).
tt = find(t<T);

# numero de harmônicos usados na análise
M = 100;

# índices para os quais calcularemos os coeficientes de Fourier
m = -M:M;

# inicialização do vetor de coeficientes de Fourier
X = zeros(length(m),1);

# cálculo dos coeficientes de acordo com a equação de análise.
# observe que o último termo (t(2)-t(1)) corresponde ao "tempo"
# transcorrido entre uma amostra e outra, e serve para adequar
# o resultado da soma ao valor da integral correspondente.
for j=1:length(m)
  X(j) = (1/T)*sum(x(tt).*exp(-i*m(j)*w*t(tt)))*(t(2)-t(1));
endfor

disp("Parte real dos coeficientes");
plotlim(m,real(X),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Zoom nos coeficientes próximos de zero (primeiros harmônicos)");
# compare os valores com os resultados calculados em aula:
# F0 = 0.5
# Fn = seno(n*pi/2)/(n*pi)
plotlim(m(81:120),real(X)(81:120),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Parte imaginária dos coeficientes");
# Como são # todos reais, o resultado deve ser 0
# (na realidade existe um pequeno erro numérico
# pela aproximação da integral por uma soma finita).
plotlim(m,imag(X),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Reconstrução do sinal a partir dos harmônicos");
# etapa de reconstrução do sinal original usando os
# primeiros M harmônicos, progressivamente

# C é o índice do vetor X que corresponde a m=0
# que será exatamente igual a M+1
C = M+1;

# inicializa um sinal do tamanho do sinal original
# e soma o primeiro harmônico (usamos real(X(C))
# para eliminar algum erro numérico, pois X(C)=X0
# deveria ser um número real puro
y = 0*x+real(X(C));
plotlim(t,y,-2,2);

# constroi para cada índice j=1,2,...,M o j-ésimo
# harmônico e soma ao sinal anterior, atualizando
# o gráfico (neste caso vamos pular os harmônicos
# pares que são identicamente nulos)

disp("Tenha paciência, isso pode demorar...");

for j=1:2:M
  # a fórmula a seguir usa o operador real() apenas
  # para eliminar possíveis erros numéricos, pois
  # os valores seriam reais (se a precisão fosse infinita)
  #
  h = real(X(C-j)*exp(i*(-j)*w*t)+X(C+j)*exp(i*j*w*t));
  #
  # outra forma de calcular a mesma expressão usa
  # as simplificações vistas em aula e a representação
  # polar de Xn (obtida através das funções abs() e arg()
  # para escrever o j-ésimo harmônico como:
  #
  # h = 2*abs(X(C+j))*cos(j*w*t+arg(X(C+j)));
  #
  # aparentemente o octave é igualmente lento
  # para computar qualquer uma delas...

  # adiciona à aproximação anterior e plota
  y += h;
  plotlim(t,y,-2,2);
endfor

disp("Pressione qualquer tecla...");pause;







# Repete o exemplo anterior para um sinal dente-de-serra
# oscilando entre -1 e 1, com período 2 seg e com fase
# inicial de pi (ou seja, em t=0 estamos no meio de um
# ciclo

disp("Função dente-de-serra a ser analisada");

# fórmula compacta para o dente-de-serra
x = mod(t-1,2)-1;
plotlim(t,x,-2,2);

disp("Pressione qualquer tecla...");pause;

# Calcula os coeficientes da série de Fourier

# período
T = 2;

# frequência angular fundamental
w = 2*pi/T;

# conjunto de índices que correspondem a um período
# da forma de onda (de 0 a T seg).
tt = find(t<T);

# numero de harmônicos usados na análise
M = 100;

# índices para os quais calcularemos os coeficientes de Fourier
m = -M:M;

# inicialização do vetor de coeficientes de Fourier
X = zeros(length(m),1);

# cálculo dos coeficientes de acordo com a equação de análise.
# observe que o último termo (t(2)-t(1)) corresponde ao "tempo"
# transcorrido entre uma amostra e outra, e serve para adequar
# o resultado da soma ao valor da integral correspondente.
for j=1:length(m)
  X(j) = (1/T)*sum(x(tt).*exp(-i*m(j)*w*t(tt)))*(t(2)-t(1));
endfor

disp("Parte real dos coeficientes");
# devem ser todos zero a menos de algum erro numérico
plotlim(m,real(X),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Parte imaginária dos coeficientes");
plotlim(m,imag(X),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Zoom nos coeficientes próximos de zero (primeiros harmônicos)");
# compare os valores com os resultados calculados nas notas de aula:
# X0 = 0
# Xn = i*(-1)^n/(n*pi)
plotlim(m(81:120),imag(X)(81:120),-1,1);

disp("Pressione qualquer tecla...");pause;

disp("Reconstrução do sinal a partir dos harmônicos");
# etapa de reconstrução do sinal original usando os
# primeiros M harmônicos, progressivamente

# C é o índice do vetor X que corresponde a m=0
# que será exatamente igual a M+1
C = M+1;

# inicializa um sinal do tamanho do sinal original
# e soma o primeiro harmônico
y = 0*x+real(X(C));
plotlim(t,y,-2,2);

disp("Tenha paciência, isso pode demorar muito...");

# constroi para cada índice j=1,2,...,M o j-ésimo
# harmônico e soma ao sinal anterior, atualizando
# o gráfico
for j=1:M
  # a fórmula a seguir usa o operador real() apenas
  # para eliminar possíveis erros numéricos, pois
  # os valores seriam reais (se a precisão fosse infinita)
  #
  h = real(X(C-j)*exp(i*(-j)*w*t)+X(C+j)*exp(i*j*w*t));
  #
  # outra forma de calcular a mesma expressão usa
  # as simplificações vistas em aula e a representação
  # polar de Xn (obtida através das funções abs() e arg()
  # para escrever o j-ésimo harmônico como:
  #
  # h = 2*abs(X(C+j))*cos(j*w*t+arg(X(C+j)));
  #
  # aparentemente o octave é igualmente lento
  # para computar qualquer uma delas...

  # adiciona à aproximação anterior e plota
  y += h;
  plotlim(t,y,-2,2);
endfor

