/*******************************************************************************
 ** BonnMotion - a mobility scenario generation and analysis tool             **
 ** Copyright (C) 2002-2005 University of Bonn                                **
 **                                                                           **
 ** This program is free software; you can redistribute it and/or modify      **
 ** it under the terms of the GNU General Public License as published by      **
 ** the Free Software Foundation; either version 2 of the License, or         **
 ** (at your option) any later version.                                       **
 **                                                                           **
 ** This program is distributed in the hope that it will be useful,           **
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of            **
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
 ** GNU General Public License for more details.                              **
 **                                                                           **
 ** You should have received a copy of the GNU General Public License         **
 ** along with this program; if not, write to the Free Software               **
 ** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA **
 *******************************************************************************/

package edu.bonn.cs.iv.bonnmotion.models;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

import edu.bonn.cs.iv.bonnmotion.BMHelper;
import edu.bonn.cs.iv.bonnmotion.MobileNode;
import edu.bonn.cs.iv.bonnmotion.Model;
import edu.bonn.cs.iv.bonnmotion.Scenario;

public class ChainScenario implements Model {

	protected static final String MODEL_NAME = "ChainScenario";

	protected Vector scenarios = new Vector();
	protected int mode = 0;
	protected boolean writeParts = false;

	public static void printHelp() {
		System.out.println(MODEL_NAME + ":");
		System.out.println("\t-m <mode>");
		System.out.println("\t  0: Fast mode (default)");
		System.out
				.println("\t  1: Move mode - nodes get 2 sec. to get to their new pos");
		System.out.println("\t-P - if set, writes the link scenarios too");
		System.out.println("\t<model> [model] [...]");
	}

	public static String[] stringArrayCut(String[] _src, int _s, int _c) {
		String[] dst = new String[_src.length - _c];
		System.arraycopy(_src, 0, dst, 0, _s);
		System.arraycopy(_src, _s + _c, dst, _s, _src.length - (_s + _c));
		return dst;
	}

	public ChainScenario(String[] args) {
		go(parseArgs(args));
	}

	public String[] parseArgs(String[] _args) {
		for (int i = 0; i < _args.length; i++) {
			if (_args[i] != null) {
				char key = _args[i].charAt(1);
				switch (key) {
				case 'm':
					mode = Integer.parseInt(_args[i + 1]);
					_args = stringArrayCut(_args, i, 2);
					i = 0;
					System.out.println("Mode: " + mode);
					break;
				case 'P':
					writeParts = true;
					_args = stringArrayCut(_args, i, 1);
					System.out.println("Will write parts.");
					i = 0;
					break;
				default:
					break;
				}
			}
		}
		return _args;
	}

	private void go(String[] args) {
		args = BMHelper.removeFirstElements(args, 1);
		Scenario s = null;
		Scenario s_old = null;
		for (int i = 0; i < args.length; i++) {
			String[] sArgs = args[i].split(" ");
			System.out.println("  Starting Model(" + i + "): " + sArgs[0]);
			Class c = BMHelper.str2class(sArgs[0]);

			sArgs[0] = null;
			Class[] cType = { String[].class, Scenario.class, Integer.class };
			Object[] cParam = { sArgs, s_old, new Integer(mode) };
			try {
				s = (Scenario) c.getConstructor(cType).newInstance(cParam);
				scenarios.add(s);
				s_old = s;
			} catch (Exception e) {
				System.out.println("Error: " + e);
				e.printStackTrace();
				System.exit(-1);
			}
			System.out.println("  done.");
		}
	}

	public void write(String _basename) throws FileNotFoundException,
			IOException {
		PrintWriter info = new PrintWriter(new FileOutputStream(_basename
				+ ".params"));
		info.println("model=ChainScenario");

		for (int i = 0; i < scenarios.size(); i++) {
			Model m = (Model) scenarios.get(i);
			String modelBasename = _basename + "-" + m.getModelName() + "-" + i;
			info.println("linkModelParams=" + modelBasename);
			if (writeParts)
				m.write(modelBasename);
		}

		String modelAllBasename = _basename + "-ALL";
		info.println("modeAll=" + modelAllBasename);
		makeMixedScenario().write(modelAllBasename);

		info.close();
	}

	public String getModelName() {
		return MODEL_NAME;
	}

	public Scenario makeMixedScenario() {
		double x = 0, y = 0; // die Endg�ltige Gr��e des Scenarios.
		Scenario s = (Scenario) scenarios.get(0);
		MobileNode[] mixedSmn = new MobileNode[s.getNode().length];
		double duration = 0;

		for (int i = 0; i < s.getNode().length; i++)
			mixedSmn[i] = new MobileNode();

		for (int i = 0; i < scenarios.size(); i++) {
			s = (Scenario) scenarios.get(i);
			x = Math.max(x, s.getX());
			y = Math.max(y, s.getY());
			duration += s.getDuration();
			MobileNode[] mn = s.getNode();
			for (int j = 0; j < mn.length; j++) {
				mixedSmn[j].add(mn[j]);
			}
		}

		Scenario mixedS = new Scenario(s.getNode().length, x, y, duration, s
				.getIgnore(), s.getRandomSeed());
		mixedS.setModelName(MODEL_NAME);
		mixedS.setNode(mixedSmn);
		return mixedS;
	}
}
