package edu.bonn.cs.iv.bonnmotion;

public class BMHelper {

	public final static String MODELS_PACK = "edu.bonn.cs.iv.bonnmotion.models";
	public final static String MODELS[] = { "GaussMarkov",
			"Gauss-Markov model", "OriginalGaussMarkov",
			"The original Gauss-Markov model", "ManhattanGrid",
			"Manhattan Grid model", "RandomWaypoint", "Random Waypoint model",
			"RPGM", "Reference Point Group Mobility model", "Static",
			"static network (no movement at all)", "ChainScenario",
			"links different scenarios" };
	public final static String APPS_PACK = "edu.bonn.cs.iv.bonnmotion.apps";
	public final static String APPS[] = { "Cut",
			"extract certain time span from scenario", "LinkDump",
			"Dump information about links", "NSFile",
			"Create scenario files for ns-2", "GlomoFile",
			"Create scenario files for Glomosim and Qualnet", "SPPXml",
			"Create motion file according to Horst Hellbr�cks XML schema",
			"Statistics", "Analyse scenario", "Visplot",
			"Visualise node movements" };

	/**
	 * Converts a classname into a Class object
	 * 
	 * @return class object
	 */
	@SuppressWarnings("unchecked")
	public static Class str2class(String _class) {
		try {
			for (int i = 0; i < BMHelper.MODELS.length; i += 2)
				if (BMHelper.MODELS[i].equals(_class))
					return Class.forName(BMHelper.MODELS_PACK + "." + _class);
			for (int i = 0; i < BMHelper.APPS.length; i += 2)
				if (BMHelper.APPS[i].equals(_class))
					return Class.forName(BMHelper.APPS_PACK + "." + _class);
			return Class.forName(_class);
		} catch (Exception e) {
			App.exceptionHandler("Error in BM ", e);
			// System.out.println("Could not execute \"" + _class + "\": " + e);
		}
		return null; // should never be reached
	}

	public static String[] removeFirstElements(String[] array, int n) {
		String[] r = new String[array.length - n];
		System.arraycopy(array, n, r, 0, r.length);
		return r;
	}

}
