package teste;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public abstract class Teste {
	private static final String HOST_URL = "http://eclipse.ime.usp.br:9090/batalha";

	protected int conectaJogador(String mensagem) throws Exception {
		HttpConnection http = abreConexao();
		DataInputStream in = enviaRequisicao(http,
				new String[] { "op=conecta" });

		assertEquals("Mensagem do conectar foi diferente", "OK " + mensagem, in
				.readUTF());

		int id = in.readInt();
		in.close();
		http.close();
		return id;
	}

	protected void pingServidor(int idJogador, String mensagem, String outraMsg)
			throws Exception, IOException {
		HttpConnection http = abreConexao();
		DataInputStream in = enviaRequisicao(http, new String[] { "op=ping",
				"id=" + idJogador });
		assertEquals("Mensagem do ping foi diferente", "OK " + mensagem, in
				.readUTF());
		if (outraMsg != null)
			assertEquals("Outra mensagem do ping foi diferente", outraMsg, in
					.readUTF());
	}

	protected void enviaTabuleiro(int jogador, String mensagem, String outraMsg)
			throws Exception {
		HttpConnection http = abreConexao();
		DataInputStream in = enviaRequisicao(http,
				new String[] { "op=tabuleiro", "id=" + jogador,
						"portaavioes=G2,G3,G4,H3", "encouracado=B9,C9,D9,E9",
						"cruzador=A2,B2,C2", "cruzador=I6,I7,I8",
						"submarino=B6,C6", "submarino=G8,G9",
						"submarino=E3,E4", "bote=B4", "bote=I10", "bote=J2",
						"bote=F6" });
		assertEquals("Primeira mensagem de receber tabuleiro foi diferente",
				"OK " + mensagem, in.readUTF());
		if (outraMsg != null)
			assertEquals("Segunda mensagem de receber tabuleiro foi diferente",
					outraMsg, in.readUTF());
	}

	protected void enviaJogada(int jogador, String jogada, String resposta,
			String outraResp) throws Exception {
		HttpConnection http = abreConexao();
		DataInputStream in = enviaRequisicao(http, new String[] { "op=joga",
				"id=" + jogador, "posicao=" + jogada });

		assertEquals("Resposta da jogada deve ser como esperada", "OK " + resposta, in
				.readUTF());
		if (outraResp != null)
			assertEquals("Outra resposta da jogada deve ser como esperada", outraResp, in
					.readUTF());
	}

	protected void recebe(int jogador, String resposta, String posicao)
			throws Exception {
		HttpConnection http = abreConexao();
		DataInputStream in = enviaRequisicao(http, new String[] {"op=recebe","id="+jogador});

		assertEquals("Resposta do recebe deve ser como esperada", "OK " + resposta, in
				.readUTF());
		if (posicao != null)
			assertEquals("Posicao do recebe deve ser como esperada", "posicao="+posicao, in
					.readUTF());
	}

	protected HttpConnection abreConexao() throws IOException {
		HttpConnection http = (HttpConnection) Connector.open(HOST_URL);
		http.setRequestMethod(HttpConnection.POST);
		http.setRequestProperty("Content-Type", "application/octet-stream");
		return http;
	}

	protected DataInputStream enviaRequisicao(HttpConnection http,
			String[] params) throws IOException {
		DataOutputStream output = http.openDataOutputStream();
		for (int i = 0; i < params.length; i++) {
			output.writeUTF(params[i]);
		}
		output.close();
		return http.openDataInputStream();
	}

	public void assertEquals(String msg, Object expected, Object actual) {
		if (expected != null) {
			if (!expected.equals(actual)
					&& !expected.toString().equals(actual.toString()))
				System.out.println(msg + " expected $" + expected + "$ / had $"
						+ actual + "$");
		} else if (actual != null)
			System.out.println(msg + " expected $" + expected + "$ / had $"
					+ actual + "$");
	}

	public String[] split2(String s, String p) {
		int posP = s.indexOf(p);
		String[] ss = new String[2];
		ss[0] = s.substring(0, posP);
		ss[1] = s.substring(posP + p.length());
		return ss;
	}
}
