-- usa s para acessar o vetor sinal103 do Pd
local s = ofArray("sinal103")

-- função que cria formas de onda diversas
-- x é um valor entre [0,1] que varre o domínio da forma de onda
-- tipo é:
-- 0=senoide
-- 1=quadrada
-- 2=triangular
-- 3=dente-de-serra
-- 4=ruído branco
local function f(x, tipo)
    if tipo==0 then
        return math.sin(2*math.pi*x)
    elseif tipo==1 then
        return (x<=0.5 and 1) or -1
    elseif tipo==2 then
        return (x<=0.25 and x/0.25) or (x<0.75 and -(x-0.5)/0.25) or (x-1)/0.25
    elseif tipo==3 then
        return 2*x-1
    elseif tipo==4 then
        return 2*math.random()-1
    -- se o tipo é outro, usa silêncio
    else return 0
    end
end

-- a tabela do Pd tem tamanho 2^k+3
-- para ser usada com [tabosc4~]
N=s:getSize()-3
-- preenche com os valores da função selecionada
-- computando amplitudes
pico,media,rms=0,0,0
for i = 0, N-1 do
    s[i] = f(i/N, a)
    pico = math.max(pico,math.abs(s[i]))
    media = media+math.abs(s[i])/N
    rms = rms+s[i]^2/N
end
rms = math.sqrt(rms)
-- copia os valores de "sentinela" para o [tabosc4~]
s[N], s[N+1], s[N+2] = s[0], s[1], s[2]
-- devolve valores de amplitude
return {pico, media, rms}
