# flag para depuração
__DEBUG__ = False


# Variaveis globais (do módulo) que o mundo acessa para passar informações para a personagem.

global nFlechas
"""
Número de flechas que a personagem possui. Serve apenas para
consulta da personagem, pois o mundo mantém uma cópia "segura" dessa
informação (não tente inventar flechas...).
"""

global mundoCompartilhado
"""
Esse é um espaço onde a personagem tem acesso à representação do
mundo de uma outra personagem.  Essa informação pode ser usada como a
personagem quiser (por exemplo, transferindo o conteúdo para o seu
próprio "mundo", ou mantendo uma lista dos vários mundos
compartilhados com outras personagens).
"""


# Outras variaveis globais do modulo personagemNUSP

global N
""" Dimensao do mundo.
"""

global mundo
"""
Representa o conhecimento da personagem em relação ao Mundo de
Wumpus. Essa é uma matriz de NxN onde a personagem toma notas de suas
percepções ao longo do caminho que percorre, indicando os muros, as
salas livres e as salas percorridas, bem como a proximidade de perigos
(poços e Wumpus). A geometria do mundo é a de um toro (aquela figura
que parece um donut!) onde existem sempre 4 salas vizinhas à posição
[i][j]: em sentido horário e a partir da (nossa) direita essas seriam:
[i][(j+1)%N], [(i+1)%N][j], [i][(j-1)%N] e [(i-1)%N][j]. Cada entrada
mundo[i][j] é uma lista de anotacoes/rotulos correspondentes às
informacoes encontradas ou deduzidas pela personagem sobre o conteúdo
da sala (i,j).
"""

global posicao
"""
Representa a posição relativa da personagem no mundo. Cada
personagem começa em uma posição aleatória (e desconhecida por ela,
pois não possui GPS ou equivalente) do Mundo "real" de Wumpus, e por
isso precisa usar um sistema de coordenadas pessoal para se orientar.
Por convenção, sua posição inicial é representada como [0,0] (canto
superior esquerdo) nesse sistema. Como o mundo não tem bordas, podemos
usar sempre os i=0,...,N-1 e j=0,...,N-1, que percorrem todas as salas
possíveis do Mundo de Wumpus, usando o operador módulo (%) para
corrigir a posição quando um passo nos levar a uma sala de índice <0
ou >=N.
"""

global orientacao
"""
Juntamente com a posicao relativa, permite a personagem manter o
historico das salas visitadas. Essa orientacao é independente da
orientacao "real" que o mundo usa para coordenar a acao de todas as
personagens. Por convencao, todas as personagens indicam sua orientação
inicial como "para baixo" ou "sul", correspondente a direcao [1,0]
(direcao do eixo vertical).
"""
posAnt=[0,0]
global caminho#plano sendo executado
global per
#global mundoCam#número de caminhos possiveis
global caminhosPossiveis
global giro#altera qual direção prevalece
global conhecidos#lista de personagens encontrados
global cooldown#matriz que impede que compartilhe com o mesmo personagem novamente antes de passar-se certo tempo.
global plano
def inicializa(tamanho):
    """ Função de inicializacao da personagem (recebe o tamanho do mundo).
        Usa as variaveis globais (do modulo) para representar seu
        conhecimento do mundo, sua posicao e sua orientacao relativas
        ao início da simulacao. Você pode criar e inicializar outras
        variaveis aqui (por exemplo, a lista de salas livres e nao
        visitadas).

    """
    # declara as variaveis globais que serao acessadas
    global N, mundo, posicao, orientacao,caminhosPossiveis,per,caminho,giro,cooldown,conhecidos
    # guarda o tamanho do mundo
    N = tamanho
    # cria a matriz NxN com a representação do mundo conhecido
    conhecidos=[]
    caminho=False
    mundo = []
#    nonlocal mundoPer
#    mundoPer=[]#Mapa de percepções
    cooldown=[]
    giro=-1
    per=[]
    caminhosPossiveis=[[1,0]]
    for i in range(N):
        mundo.append([])
        for j in range(N):
            mundo[i].append([]) # começa com listas vazias
#    mundoCam=[]
#    for i in range(N):
#        mundoCam.append([])
#        for j in range(N):
#            mundoCam[i].append(0) # começa com listas vazias
    # posição e orientação iniciais da personagem (sempre serão [0,0] e [1,0]).
    posicao = [0,0]#y,x
    orientacao = [1,0]


def planejar(percepcao):
    """ Nessa função a personagem deve atualizar seu conhecimento
        do mundo usando sua percepção da sala atual. Através desse
        parâmetro a personagem recebe (do mundo) todas as informações
        sensoriais associadas à sala atual, bem como o feedback de
        sua última ação.
        Essa percepção é uma lista de strings que podem valer:
            "F" = fedor do Wumpus em alguma sala adjacente,
            "B" = brisa de um poço em sala adjacente,
            "I" para impacto com uma parede,
            "U" para o urro do Wumpus agonizante e
            "Nome" quando uma outra personagem é encontrada.
    """
    safe=["L","V","B","F"]
    def checkSafe(safe,quadrado):
        for i in range(len(safe)):
            if safe[i] in quadrado:
                return True

    global mundo, posicao, orientacao, nFlechas, mundoCompartilhado,per
    for z in range(len(percepcao)):
        per.append(percepcao[z])

    if __DEBUG__:
        print("Percepção recebida pela personagem:")
        print(percepcao)
        # elimine o teste abaixo quando tiver corrigido o bug de movimentação...
    if "I" in percepcao:
        print("Você bateu num muro e continua na mesma sala")
    # essa atualização abaixo serve de ilustração/exemplo, e
    # apenas marca as salas como "Visitadas", mas está errada
#    posAnt[0]=pos[0]
#    posAnt[1]=pos[1]
    pos = posicao
    ori = orientacao
    if "I" in percepcao:
         mundo[pos[0]][pos[1]]=['M']
         pos[0]=(pos[0]-ori[0])%len(mundo)
         pos[1]=(pos[1]-ori[1])%len(mundo)
    if pos!=posAnt:
        mundo[pos[0]][pos[1]].append("V")
        if len(percepcao)!=0:
            for i in range(-1,2):
                for j in range(-1,2):
                    quadrado=mundo[(pos[0]+i)%len(mundo)][(pos[1]+j)%len(mundo[0])]
                    if not checkSafe(safe,quadrado) and not ("W?" in quadrado or quadrado=="W" or "P?" in quadrado or quadrado=="P") and ((i==0)!=(j==0)):
                        mundo[(pos[0]+i)%len(mundo)][(pos[1]+j)%len(mundo[0])]=["P?"]
    if pos!=posAnt:
        if len(percepcao)!=0:
            if not ("B" in mundo[pos[0]][pos[1]] or "F" in mundo[pos[0]][pos[1]]):
                if mundo[pos[0]][pos[1]]==["L"]:
                    mundo[pos[0]][pos[1]]=[]
                for z in range(len(percepcao)):
                    if percepcao[z] in ["B","F"]:
                        mundo[pos[0]][pos[1]].append(percepcao[z])
        elif "L" in mundo[pos[0]][pos[1]] or not (checkSafe(safe,mundo[pos[0]][pos[1]]) or "P?" in mundo[pos[0]][pos[1]] or "W?" in mundo[pos[0]][pos[1]] or "P" in mundo[pos[0]][pos[1]] or "W" in mundo[pos[0]][pos[1]]):
            for index in range(len(mundo[pos[0]][pos[1]])):
                if mundo[pos[0]][pos[1]][index]=="L":
                   del mundo[pos[0]][pos[1]][index]
                   index=len(mundo[pos[0]][pos[1]])+1
                if mundo[pos[0]][pos[1]][index]=="P?":
                   del mundo[pos[0]][pos[1]][index]
                   index=len(mundo[pos[0]][pos[1]])+1
                if mundo[pos[0]][pos[1]][index]=="W?":
                   del mundo[pos[0]][pos[1]][index]
                   index=len(mundo[pos[0]][pos[1]])+1
                if mundo[pos[0]][pos[1]][index]=="P":
                   del mundo[pos[0]][pos[1]][index]
                   index=len(mundo[pos[0]][pos[1]])+1
                if mundo[pos[0]][pos[1]][index]=="W":
                   del mundo[pos[0]][pos[1]][index]
                   index=len(mundo[pos[0]][pos[1]])+1

    # mostra na tela (para o usuário) o mundo conhecido pela personagem
    # e o mundo compartilhado (quando disponível)
    if __DEBUG__:
        print("Mundo conhecido pela personagem:")
        for i in range(len(mundo)):
            for j in range(len(mundo[0])):
                if pos==[i,j]:
                    if ori==[0,-1]:
                         print("<",end="")
                    print("X",end="")
                    if ori==[0,1]:
                         print(">",end="")
                    if ori==[1,0]:
                        print("v",end="")
                    if ori==[-1,0]:
                        print("^",end="")
                print("".join(mundo[i][j]),end="\t| ")
            print("\n"+"-"*(8*len(mundo)+1))
        print("Mundo conhecido do Dummy:")
        for i in range(len(mundo)):
            for j in range(len(mundo[0])):
                if pos==[i,j]:
                    if ori==[0,-1]:
                         print("<",end="")
                    print("X",end="")
                    if ori==[0,1]:
                         print(">",end="")
                    if ori==[1,0]:
                        print("v",end="")
                    if ori==[-1,0]:
                        print("^",end="")
                print("".join(mundoCompartilhado[i][j]),end="\t| ")
            print("\n"+"-"*(8*len(mundo)+1))
                

    if "P?" in mundo[pos[0]][pos[1]]:
        end=len(mundo[pos[0]][pos[1]])
        index=0
        while index<end:
            if mundo[pos[0]][pos[1]][index]=="P?":
               del mundo[pos[0]][pos[1]][index]
               index=end
            index+=1
    if "W?" in mundo[pos[0]][pos[1]]:
        end=len(mundo[pos[0]][pos[1]])
        index=0
        while index<end:
            if mundo[pos[0]][pos[1]][index]=="W?":
               del mundo[pos[0]][pos[1]][index]
               index=end
            index+=1

    if not("B" in percepcao or "F" in percepcao):
        for iCount in range(-1,2):
            for jCount in range(-1,2):
                quadrado=mundo[(pos[0]+iCount)%len(mundo)][(pos[1]+jCount)%len(mundo[0])]
                if ((iCount==0)!=(jCount==0)):
                    if not "B" in percepcao:
                        index=0
                        while index<len(quadrado):
                            if quadrado[index]=="P" or quadrado[index]=="P?":
                                quadrado[index]="L"
                                index=len(quadrado)
                            index+=1
                    if not "F" in percepcao:
                        index=0
                        while index<len(quadrado):
                            if quadrado[index]=="W" or quadrado[index]=="W?":
                                quadrado[index]="L"
                                index=len(quadrado)
                            index+=1

    for i in range(len(mundo)):#Analisa mundo
        for j in range(len(mundo[0])):
            countW=0
            countP=0
            for iCount in range(-1,2):
                for jCount in range(-1,2):
                    if "B" in mundo[(i+iCount)%len(mundo)][(j+jCount)%len(mundo[0])] and ((iCount==0) != (jCount==0)):
                        countP+=1
                    if "F" in mundo[(i+iCount)%len(mundo)][(j+jCount)%len(mundo[0])] and ((iCount==0) != (jCount==0)):
                        countW+=1
                    if countW==4: mundo[i][j].append("W")
                    if countP==4: mundo[i][j].append("P")


def agir():
    """ Nessa função a personagem deve usar seu conhecimento
        do mundo para decidir e tentar executar (devolver) uma ação.
        Possíveis ações (valores de retorno da função) são
        "A"=Andar, "D"=girarDireita, "E"=girarEsquerda,
        "T"=aTirar e "C"=Compartilhar.
    """
    # declara as variáveis globais que serão acessadas
    global mundo, posicao, orientacao, nFlechas, mundoCompartilhado, per,caminhosPossiveis,caminho,giro,conhecidos,cooldown,plano

 
    for z in range(len(conhecidos)):
        if conhecidos[z] in cooldown:
            cooldown[z][1]+=-1


    safe=["L","V","B","F"]
    def checkSafe(safe,quadrado):
        for i in range(len(safe)):
            if safe[i] in quadrado:
                return True
    pos = posicao
    ori = orientacao
    moved=True
    if posAnt==pos:moved=False
    posAnt[0]=pos[0]
    posAnt[1]=pos[1]
    giro+=1
    acao=None
    if mundo[(pos[0]+ori[0])%len(mundo)][(pos[1]+ori[1])%len(mundo[0])]=="W" and nFlechas>0 and not "U" in per:
       acao="T"
    else:
        if caminho==False:
            caminhosPossiveis=[]
            for iCount in range(-1,2):
                for jCount in range(-1,2):
                    if ((iCount==0)!=(jCount==0)):
                        quadrado=mundo[(pos[0]+iCount)%len(mundo)][(pos[1]+jCount)%len(mundo[0])]
                        if not("W?" in quadrado or "W" in quadrado or "P?" in quadrado or "P" in quadrado or "M" in quadrado) and quadrado!=posAnt:
                            caminhosPossiveis.append([iCount-pos[0],jCount-pos[1]])
                            caminho=True
            if caminhosPossiveis==[] and moved:
                plano=[-ori[0],-ori[1]]
                caminho=True
            elif caminhosPossiveis!=[]:
                giro=giro%len(caminhosPossiveis)
                plano=[caminhosPossiveis[giro][0],caminhosPossiveis[giro][1]]
        if plano!=ori:
            if (ori[0]==-plano[0] and ori[1]==-plano[1]):
                acao="D"
            if (ori[0]==0 and ori[0]==plano[1] and ori[1]==plano[0]) or (ori[0]!=0 and ori[0]==-plano[1] and ori[1]==-plano[0]):
                acao="D"
            if (ori[1]==0 and ori[0]==plano[1] and ori[1]==plano[0]) or (ori[1]!=0 and ori[0]==-plano[1] and ori[1]==-plano[0]):
                acao="E"
            caminho=True
        else:
            caminho=False
            acao="A"
    for z in range(len(per)):
        if not per[z] in ["B","F","U","I"]:
           if not per[z] in conhecidos:
               conhecidos.append(per[z])
               cooldown.append([per[z],5])
           else:
               if cooldown[conhecidos.index(per[z])][1]<1:
                   acao="C"
#    acao = input("Digite a ação desejada (A/D/E/T/C): ")
    if acao==None:
        acao="A"
    if acao=="A":
        pos[0] = (pos[0]+ori[0])%len(mundo)
        pos[1] = (pos[1]+ori[1])%len(mundo)
    if acao=="E":
        if ori[0]==0:
            ori[1] = -ori[1]
        ori[0],ori[1] = ori[1],ori[0]
    if acao=="D":
        if ori[1]==0:
            ori[0] = -ori[0]
        ori[0],ori[1] = ori[1],ori[0]
 

    assert acao in ["A","D","E","T","C"]
    return acao
