package datasource;

import java.sql.*;
import java.util.Properties;

public class DB {
    // MODIFIQUE O VALOR DESTAS CONSTANTES COM OS DADOS DO SEU BD
    public static final String NOME_DRIVER = "org.postgresql.Driver";
    public static final String URL_BD = "jdbc:postgresql://postgresql.linux.ime.usp.br:5432/SEU_USUARIO";
    public static final String USUARIO_BD = "SEU_USUARIO";
    public static final String SENHA_BD = "SUA_SENHA";

    private static Connection conn;

    public static void init() throws SQLException, ClassNotFoundException {
            Class.forName("org.postgresql.Driver");
            
            Properties props = new Properties();
            props.setProperty("ssl","true");
            props.setProperty("sslfactory","org.postgresql.ssl.NonValidatingFactory");
            props.setProperty("user", USUARIO_BD);
            props.setProperty("password", SENHA_BD);

            conn = DriverManager.getConnection(URL_BD, props);
    }

    public static Statement createStatement() throws SQLException {
            return conn.createStatement();
    }

    public static PreparedStatement prepareStatement(String sql) throws SQLException {
            return conn.prepareStatement(sql);
    }

    public static void terminate() throws Exception {
            if (conn == null) {
                    return;
            }
            try {
                    if (conn.isClosed() == false) {
                            conn.close();
                    }
            } catch (SQLException ignore) {
            }
    }
}
