create schema bd_filmes;
set search_path to bd_filmes;

----- Create Tables -----

CREATE TABLE Filme (
 titulo VARCHAR(255) NOT NULL,
 ano INTEGER NOT NULL,
 duracao INTEGER,
 colorido CHAR(1),
 nome_estudio CHAR(50),
 num_certificado_produtor INTEGER
);

CREATE TABLE EstrelaDeCinema (
 nome CHAR(30) NOT NULL,
 endereco VARCHAR(255),
 sexo CHAR(1),
 data_nascimento TIMESTAMP WITH TIME ZONE
);

CREATE TABLE ElencoDeFilme (
    titulo_filme VARCHAR(255) NOT NULL,
    ano_filme INTEGER NOT NULL,
    nome_estrela CHAR(30) NOT NULL
);

CREATE TABLE ExecutivoDeCinema (
    num_certificado INTEGER NOT NULL,
    nome CHAR(30),
    endereco VARCHAR(255),
    patrimonio INTEGER
);

CREATE TABLE Estudio (
    nome CHAR(50) NOT NULL,
    endereco VARCHAR(255),
    num_certificado_presidente INTEGER
);

----- Create Constraints -----
ALTER TABLE Filme ADD CONSTRAINT PK_Filme PRIMARY KEY(titulo,ano);

ALTER TABLE EstrelaDeCinema ADD CONSTRAINT PK_EstrelaDeCinema PRIMARY KEY(nome);

ALTER TABLE ExecutivoDeCinema ADD CONSTRAINT PK_ExecutivoDeCinema PRIMARY KEY(num_certificado);

ALTER TABLE Estudio ADD CONSTRAINT PK_Estudio PRIMARY KEY(nome);

ALTER TABLE ElencoDeFilme ADD CONSTRAINT PK_ElencoDeFilme PRIMARY KEY(titulo_filme,ano_filme,nome_estrela);

ALTER TABLE Filme ADD CONSTRAINT FK_Filme_ExecutivoDeCinema FOREIGN KEY(num_certificado_produtor) REFERENCES ExecutivoDeCinema(num_certificado);

ALTER TABLE Filme ADD CONSTRAINT FK_Filme_Estudio FOREIGN KEY(nome_estudio) REFERENCES Estudio(nome);

ALTER TABLE ElencoDeFilme ADD CONSTRAINT FK_ElencoDeFilme_Filme FOREIGN KEY(titulo_filme, ano_filme) REFERENCES Filme(titulo, ano);

ALTER TABLE ElencoDeFilme ADD CONSTRAINT FK_ElencoDeFilme_EstrelaDeCinema FOREIGN KEY(nome_estrela) REFERENCES EstrelaDeCinema(nome);

------- Insert Estudio ------------
INSERT INTO Estudio
  VALUES ('Disney','500 S. Buena Vista Street',555);

INSERT INTO Estudio
  VALUES ('USA Entertainm.','', 777);

INSERT INTO Estudio
  VALUES ('Fox','10201 Pico Boulevard', 222);

INSERT INTO Estudio
  VALUES ('Paramount','5555 Melrose Ave', 111);

INSERT INTO Estudio
  VALUES ('MGM','MGM Boulevard', 123);
  
------- Insert ExecutivoDeCinema ------------  
INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('George Lucas', '90 Oak Rd.', 555, 200000000);

INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('Ted Turner', '23 Turner Av.', 333, 125000000);

INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('Stephen Spielberg', '123 ET road', 222, 100000000);

INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('Merv Griffin', '867 Riot Rd.', 444, 112000000);

INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('Jack Nicholson', 'One Washington Square', 888, 20000000);

INSERT INTO ExecutivoDeCinema (nome, endereco, num_certificado, patrimonio)
  VALUES ('Sandra Bullock', '456 5th Street', 111, 175000000);

------- Insert Filme ------------
INSERT INTO Filme
  VALUES ('Pretty Woman', 1990, 119, 'Y', 'Disney', 444);

INSERT INTO Filme
  VALUES ('The Man Who Wasn''t There', 2001, 116, 'N', 'USA Entertainm.',
    555);

INSERT INTO Filme
  VALUES ('Logan''s run', 1976, NULL, 'Y', 'Fox', 333);

INSERT INTO Filme
  VALUES ('Star Wars', 1977, 124, 'Y', 'Fox', 555);

INSERT INTO Filme
  VALUES ('Empire Strikes Back', 1980, 111, 'Y', 'Fox', 555);

INSERT INTO Filme
  VALUES ('Star Trek', 1979, 132, 'Y', 'Paramount', 222);

INSERT INTO Filme
  VALUES ('Star Trek: Nemesis', 2002, 116, 'Y', 'Paramount', 888);

INSERT INTO Filme
  VALUES ('Terms of Endearment', 1983, 132, 'Y', 'MGM', 888);

INSERT INTO Filme
  VALUES ('The Usual Suspects', 1995, 106, 'Y', 'MGM', 444);

INSERT INTO Filme
  VALUES ('Gone With the Wind', 1938, 238, 'Y', 'MGM', 888);

------- Insert EstrelaDeCinema ------------

INSERT INTO EstrelaDeCinema
  VALUES ('Jane Fonda', 'Turner Av.', 'F', '1977-07-07');

INSERT INTO EstrelaDeCinema
  VALUES ('Alec Baldwin', 'Baldwin Av.', 'M', '1977-07-06');

INSERT INTO EstrelaDeCinema
  VALUES ('Kim Basinger', 'Baldwin Av.', 'F', '1979-07-05');

INSERT INTO EstrelaDeCinema
  VALUES ('Harrison Ford', 'Prefect Rd.', 'M', '1955-05-05');

INSERT INTO EstrelaDeCinema
  VALUES ('Debra Winger', 'A way', 'F', '1978-06-05');

INSERT INTO EstrelaDeCinema
  VALUES ('Jack Nicholson', 'One Washington Square', 'M', '1949-05-05');
  
INSERT INTO EstrelaDeCinema
  VALUES ('Sandra Bullock', '456 5th Street', 'F', '1948-12-05');

------- Insert ElencoDeFilme ------------
INSERT INTO ElencoDeFilme
  VALUES ('Star Wars', 1977, 'Kim Basinger');

INSERT INTO ElencoDeFilme
  VALUES ('Star Wars', 1977, 'Alec Baldwin');

INSERT INTO ElencoDeFilme
  VALUES ('Star Wars', 1977, 'Harrison Ford');

INSERT INTO ElencoDeFilme
  VALUES ('Empire Strikes Back', 1980, 'Harrison Ford');

INSERT INTO ElencoDeFilme
  VALUES ('The Usual Suspects', 1995, 'Jack Nicholson');

INSERT INTO ElencoDeFilme
  VALUES ('Terms of Endearment', 1983, 'Jane Fonda');

INSERT INTO ElencoDeFilme
  VALUES ('Terms of Endearment', 1983, 'Jack Nicholson');

INSERT INTO ElencoDeFilme
  VALUES ('The Usual Suspects', 1995, 'Sandra Bullock');
